ALTER TABLE `multicart_users`
  ADD COLUMN `is_seller` ENUM('Y','N') NULL DEFAULT 'N' COMMENT 'seller account activated or not' AFTER `device_id`;

ALTER TABLE `multicart_artists`
  ADD COLUMN `is_vacation_mode` ENUM('Y','N') NULL DEFAULT 'N' COMMENT 'check vacation mode is activated or not' AFTER `device_id`;

ALTER TABLE `multicart_settings`
ADD COLUMN `enable_fbshare` ENUM('Y','N') NOT NULL DEFAULT 'Y' AFTER `bluepay_test_mode`,
ADD COLUMN `enable_tweet` ENUM('Y','N') NOT NULL DEFAULT 'Y' AFTER `enable_fbshare`,
ADD COLUMN `enable_gplusshare` ENUM('Y','N') NOT NULL DEFAULT 'Y' AFTER `enable_tweet`,
ADD COLUMN `enable_pinit` ENUM('Y','N') NOT NULL DEFAULT 'Y' AFTER `enable_gplusshare`,
ADD COLUMN `enable_instagram` ENUM('Y','N') NOT NULL DEFAULT 'Y' AFTER `enable_pinit`;

ALTER TABLE `multicart_settings`
  ADD COLUMN `enable_favourites` ENUM('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable Favourites list' AFTER `enable_instagram`,
  ADD COLUMN `enable_seller_account` ENUM('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable seller account activate option for buyers' AFTER `enable_favourites`;

DROP TABLE IF EXISTS `multicart_favourites`;
CREATE TABLE `multicart_favourites` (
  `nId` INT(11) NOT NULL AUTO_INCREMENT,
  `nProductId` INT(11) NOT NULL,
  `nProductOptionId` INT(11) NOT NULL,
  `nUserId` INT(11) NOT NULL,
  `seller_id` INT(11) NOT NULL,
  `dDate` DATETIME NOT NULL,
  `status` ENUM('Y','N') NOT NULL DEFAULT 'Y' COMMENT 'Y = Active , N = Deactive',
  PRIMARY KEY (`nId`),
  INDEX `nProductId` (`nProductId`, `nProductOptionId`, `nUserId`)
)
COMMENT='Store favourites Items'
COLLATE='latin1_swedish_ci'
ENGINE=MyISAM;

DROP TABLE IF EXISTS `multicart_seller_favourites`;
CREATE TABLE `multicart_seller_favourites` (
  `nId` INT(11) NOT NULL AUTO_INCREMENT,
  `nUserId` INT(11) NULL DEFAULT '0',
  `nSellerId` INT(11) NULL DEFAULT '0',
  `dDate` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY (`nId`)
)
COMMENT='store favourites sellers'
COLLATE='latin1_swedish_ci'
ENGINE=MyISAM;


ALTER TABLE `multicart_couponcode`
  ADD COLUMN `sellerId` INT NULL COMMENT 'equivalent to artist_id(StoreId)' AFTER `ccCode`;

ALTER TABLE `multicart_products`
  ADD COLUMN `alias` VARCHAR(100) NULL AFTER `seller_viewed_status`;

ALTER TABLE `multicart_products` ADD COLUMN `publish_status` CHAR(1) NULL DEFAULT 'N' AFTER `alias`, ADD COLUMN `publish_scheduled_date` DATETIME NULL AFTER `publish_status`;

ALTER TABLE `multicart_settings` ADD COLUMN `enable_product_scheduled_publishing` ENUM('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable product scheduled publishing' AFTER `enable_seller_account`, ADD COLUMN `enable_subscription_products` ENUM('Y','N') NOT NULL DEFAULT 'N' COMMENT 'Enable subscription for products' AFTER `enable_product_scheduled_publishing`; 

ALTER TABLE `multicart_products`
  ADD COLUMN `allow_free_shipping` ENUM('Y','N') NULL DEFAULT 'N' COMMENT 'Allow free shipping for products' AFTER `publish_scheduled_date`,
  ADD COLUMN `allow_subscription` ENUM('Y','N') NULL DEFAULT 'N' COMMENT 'Allow free subscription for products' AFTER `allow_free_shipping`,
  ADD COLUMN `subscription_mode` ENUM('Daily','Monthly','Yearly') NULL DEFAULT 'Monthly' COMMENT 'Subscription modes' AFTER `allow_subscription`,
  ADD COLUMN `product_tags` TEXT NULL COMMENT 'Product tags for easy searching' AFTER `subscription_mode`; 

ALTER TABLE `multicart_products`
	ADD COLUMN `publish_timezone` VARCHAR(255) NULL DEFAULT NULL COMMENT 'timezone to publish product' AFTER `product_tags`;

ALTER TABLE `multicart_products`
  CHANGE COLUMN `publish_timezone` `publish_timezone` VARCHAR(255) NULL DEFAULT NULL COMMENT 'timezone to publish product' AFTER `product_tags`;


ALTER TABLE `multicart_products`
	ADD COLUMN `seller_vacation_mode` ENUM('Y','N') NULL DEFAULT 'N' COMMENT ' N=Vacation mode  not ebaled , Y= Vacation mode enabled' AFTER `publish_timezone`;

ALTER TABLE `multicart_products`
	ADD COLUMN `default_image_small` VARCHAR(255) NULL COMMENT 'default image for listing pages' AFTER `seller_vacation_mode`,
	ADD COLUMN `default_stock` INT(11) NULL DEFAULT '0' COMMENT 'default option stock value' AFTER `default_image_small`,
	ADD COLUMN `default_additional_price` FLOAT NULL DEFAULT '0' COMMENT 'default option additional price value' AFTER `default_stock`,
	ADD COLUMN `default_shipping_weight` FLOAT NULL DEFAULT '0' COMMENT 'default option weight' AFTER `default_additional_price`,
	ADD COLUMN `default_discount` FLOAT NULL DEFAULT '0' COMMENT 'default option discount % ' AFTER `default_shipping_weight`,
	ADD COLUMN `default_discount_description` VARCHAR(250) NULL COMMENT 'default option discount description ' AFTER `default_discount`,
	ADD COLUMN `vSellerStatus` ENUM('Y','N') NULL DEFAULT 'Y' COMMENT 'seller status' AFTER `default_discount_description`,
	ADD COLUMN `default_option_id` INT NULL COMMENT 'default option id refered from product options table' AFTER `vSellerStatus`;


ALTER TABLE `multicart_products`
	CHANGE COLUMN `default_stock` `default_stock` INT(11) NULL DEFAULT '0' COMMENT 'sum of all  option stock value ' AFTER `default_image_small`,
	ADD COLUMN `seller_name` VARCHAR(255) NULL DEFAULT NULL COMMENT 'save seller name' AFTER `default_option_id`;


ALTER TABLE `multicart_cart`
  ADD COLUMN `digital_product_flag` ENUM('Y','N') NULL DEFAULT 'N' AFTER `datetime_added`,
  ADD COLUMN `gift_product_flag` ENUM('Y','N') NULL DEFAULT 'N' AFTER `digital_product_flag`;

ALTER TABLE `multicart_order_details`
  ADD COLUMN `digital_product_flag` ENUM('Y','N') NULL DEFAULT 'N' AFTER `product_commission_amount`,
  ADD COLUMN `gift_product_flag` ENUM('Y','N') NULL DEFAULT 'N' AFTER `digital_product_flag`;

ALTER TABLE `multicart_cart`
  ADD COLUMN `seller_id` INT(11) NULL AFTER `gift_product_flag`;

ALTER TABLE `multicart_settings`
  ADD COLUMN `currency_settings` ENUM('FREE','LIVE') NOT NULL DEFAULT 'FREE' COMMENT 'Settings to enable currency conversion Api ' AFTER `enable_subscription_products`;

ALTER TABLE `multicart_settings`
  ADD COLUMN `currency_api_key` VARCHAR(50) NOT NULL COMMENT 'Store Api key for production mode' AFTER `currency_settings`;

ALTER TABLE `multicart_order_details`
  ADD COLUMN `product_shipping_price` FLOAT NULL DEFAULT '0' AFTER `gift_product_flag`,
  ADD COLUMN `product_shipping_name` VARCHAR(255) NULL AFTER `product_shipping_price`,
  ADD COLUMN `allow_free_shipping` ENUM('Y','N') NULL DEFAULT 'N' AFTER `product_shipping_name`;

ALTER TABLE `multicart_cart`
  ADD COLUMN `subscription_flag` ENUM('Y','N') NULL DEFAULT 'N' COMMENT 'store subscription status of a product' AFTER `seller_id`,
  ADD COLUMN `subscription_duration` INT NULL AFTER `subscription_flag`;

ALTER TABLE `multicart_order_details`
  ADD COLUMN `subscription_product_flag` ENUM('Y','N') NULL DEFAULT 'N' AFTER `gift_product_flag`;

ALTER TABLE `multicart_users`
  ADD COLUMN `seller_id` INT NULL COMMENT 'save previleged seller id' AFTER `is_seller`;

ALTER TABLE `multicart_couponcode`
  ADD COLUMN `categoryId` INT(11) NULL DEFAULT NULL AFTER `sellerId`,
  ADD COLUMN `productId` INT(11) NULL DEFAULT NULL AFTER `categoryId`;
ALTER TABLE `multicart_couponcode`
  ADD COLUMN `coupon_type` VARCHAR(50) NOT NULL DEFAULT '' AFTER `ccStatus`;

ALTER TABLE `multicart_artists`
  ADD COLUMN `seller_time_zone` VARCHAR(100) NULL COMMENT 'Seller time zone used for publish later feature' AFTER `is_vacation_mode`;

ALTER TABLE `multicart_categories`
ADD COLUMN `alias` VARCHAR(100) NULL AFTER `avatar`;

ALTER TABLE `multicart_shipping_details`
  ADD COLUMN `seller_id` BIGINT(11) NOT NULL DEFAULT '0' AFTER `user_id`;

ALTER TABLE `multicart_orders`
  ADD COLUMN `couponCodeSeller_Id` INT(11) NOT NULL DEFAULT '0' AFTER `couponCodeDiscount`;

ALTER TABLE `multicart_orders`
  CHANGE COLUMN `couponCodeDiscount` `couponCodeDiscount` FLOAT(11) NOT NULL DEFAULT '0' AFTER `couponCode`;

ALTER TABLE `multicart_artist_payments`
  ADD COLUMN `discount_amount` FLOAT NOT NULL DEFAULT '0' AFTER `seller_viewed_status`;

ALTER TABLE `multicart_seller_favourites`
ADD COLUMN `status` ENUM('Y','N') NULL DEFAULT 'Y' AFTER `dDate`;

ALTER TABLE `multicart_users`
  ADD COLUMN `ip_address` VARCHAR(100) NULL COMMENT 'ip address of user' AFTER `seller_id`,
  ADD COLUMN `ip_location` VARCHAR(255) NULL COMMENT 'country , state,city' AFTER `ip_address`;

ALTER TABLE `multicart_couponcode`
CHANGE COLUMN `ccDiscount` `ccDiscount` FLOAT(11) NOT NULL DEFAULT '0' AFTER `ccDescription`;

DROP TABLE IF EXISTS `multicart_us_states`;
CREATE TABLE `multicart_us_states` (
  `state_id` INT(10) NULL AUTO_INCREMENT,
  `state_name` VARCHAR(100) NULL DEFAULT NULL,
  `state_abbr` VARCHAR(50) NULL DEFAULT NULL,
  `country_code` VARCHAR(50) NULL DEFAULT NULL,
  PRIMARY KEY (`state_id`)
)
COMMENT='store us states list'
COLLATE='latin1_swedish_ci'
ENGINE=MyISAM;

ALTER TABLE `multicart_homepagebanners`
  ADD COLUMN `link` VARCHAR(255) NOT NULL AFTER `created_on`;

ALTER TABLE `multicart_artists` ADD COLUMN `ip_address` VARCHAR(100) NULL COMMENT 'ip address of user' , ADD COLUMN `ip_location` VARCHAR(255) NULL COMMENT 'country , state,city'; 

ALTER TABLE `multicart_affiliate_registrations` CHANGE COLUMN `registration_date` `registration_date` DATE NULL DEFAULT NULL COMMENT 'its Order date ' AFTER `referral_charge`; 

ALTER TABLE `multicart_couponcode`
ADD COLUMN `discount_type` ENUM('PERCENTAGE','FLAT') NULL DEFAULT 'PERCENTAGE' AFTER `coupon_type`;

ALTER TABLE `multicart_orders`
  ADD COLUMN `is_subscription_order` ENUM('Y','N') NOT NULL DEFAULT 'N' AFTER `seller_viewed_status`;


ALTER TABLE `multicart_custom_fields`
  ADD COLUMN `user_id` INT(11) NULL AFTER `vcustom_delete_status`;


ALTER TABLE `multicart_settings`
	ADD COLUMN `enable_scalability_settings` ENUM('Y','N') NULL DEFAULT 'Y' AFTER `currency_api_key`;

ALTER TABLE `multicart_settings`
ADD COLUMN `enable_amazon_cdn_images` ENUM('Y','N') NULL DEFAULT 'N' AFTER `enable_scalability_settings`,
ADD COLUMN `amazon_bucket_name` VARCHAR(255) NULL AFTER `enable_amazon_cdn_images`,
ADD COLUMN `amazon_access_key` VARCHAR(255) NULL AFTER `amazon_bucket_name`,
ADD COLUMN `amazon_secret_key` VARCHAR(255) NULL AFTER `amazon_access_key`;

ALTER TABLE `multicart_custom_fields_value`
	ADD COLUMN `vcustom_field_name` TEXT NOT NULL AFTER `vfield_name_value`,
	ADD COLUMN `vcustom_field_type` TEXT NOT NULL AFTER `vcustom_field_name`;

ALTER TABLE multicart_custom_fields_value ADD COLUMN `user_id` INT(11) NULL;