drop table if exists multicart_currency_master;

CREATE TABLE multicart_currency_master (
  ncurrency_id int(11) NOT NULL auto_increment,
  vcurrency_name varchar(50) NOT NULL default '',
  vcurrency_code varchar(10) NOT NULL default '',
  vcurrency_symbol varchar(10) NOT NULL default '',
  nexchange_price float NOT NULL default '0',
  vactive char(1) NOT NULL default '',
  vcurrency_delete_status char(1) NOT NULL default '',
  PRIMARY KEY  (ncurrency_id)
) TYPE=MyISAM;

drop table if exists multicart_banners;

CREATE TABLE multicart_banners (
  nbanner_id int(11) NOT NULL auto_increment,
  vbanner_name varchar(50) NOT NULL default '',
  vbanner_locurl varchar(250) NOT NULL default '',
  vbanner_image varchar(50) NOT NULL default '',
  dbanner_date date NOT NULL default '0000-00-00',
  nbanner_display_count int(11) NOT NULL default '0',
  vbannerdelete_status char(1) NOT NULL default '',
  PRIMARY KEY  (nbanner_id)
) TYPE=MyISAM;

drop table if exists multicart_custom_form;

CREATE TABLE multicart_custom_form (
  ncustom_form_id int(11) NOT NULL auto_increment,
  vcustom_form_name varchar(50) NOT NULL default '',
  PRIMARY KEY  (ncustom_form_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS `multicart_admin_menu`;
CREATE TABLE IF NOT EXISTS `multicart_admin_menu` (
  `menu_id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(200) NOT NULL default '',
  `link` varchar(200) NOT NULL default '',
  `parent_id` smallint(4) NOT NULL default '0',
  `display_order` tinyint(4) NOT NULL default '0',
  `divname` varchar(200) NOT NULL default '',
  `status` enum('ACTIVE','INACTIVE') NOT NULL default 'ACTIVE',
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;

drop table if exists multicart_custom_fields;

CREATE TABLE multicart_custom_fields (
  ncustom_id int(11) NOT NULL auto_increment,
  vcustom_field_form_id int(11) NOT NULL default '0',
  vcustom_field_name varchar(50) NOT NULL default '',
  vcustom_field_type varchar(50) NOT NULL default '',
  vrequired_custom_field char(1) NOT NULL default '',
  vcustom_sort_order int(11) NOT NULL default '0',
  vcustom_display_field char(1) NOT NULL default '',
  vcustom_delete_status char(1) NOT NULL default '',
  PRIMARY KEY  (ncustom_id)
) TYPE=MyISAM;

drop table if exists multicart_custom_fields_value;

CREATE TABLE multicart_custom_fields_value (
  nvalue_id int(11) NOT NULL auto_increment,
  ncustom_field_id int(11) NOT NULL default '0',
  ncustom_table_id int(11) NOT NULL default '0',
  vfield_name_value varchar(50) NOT NULL default '',
  PRIMARY KEY  (nvalue_id)
) TYPE=MyISAM;

ALTER TABLE multicart_custom_fields_value CHANGE vfield_name_value vfield_name_value TEXT NOT NULL ; 
ALTER TABLE multicart_categories ADD gift_certificate_flag CHAR( 1 ) NOT NULL ;

drop table if exists multicart_giftcoupon_master;

CREATE TABLE multicart_giftcoupon_master (
  ngift_id int(11) NOT NULL auto_increment,
  ngift_product_id int(11) NOT NULL default '0',
  vgift_coupon_code varchar(250) NOT NULL default '',
  ngift_coupon_amount float NOT NULL default '0',
  ngift_coupon_products text NOT NULL,
  vgift_currency varchar(10) NOT NULL default '',
  vgift_delete_status char(1) NOT NULL default '',
  PRIMARY KEY  (ngift_id)
) TYPE=MyISAM;
RENAME TABLE `multicart_products` TO `multicart_products_backup`; 

DROP TABLE IF EXISTS `multicart_products`;
CREATE TABLE IF NOT EXISTS `multicart_products` (
  `product_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) DEFAULT NULL,
  `product_code` varchar(20) DEFAULT NULL,
  `product_description` text,
  `product_price` double DEFAULT NULL,
  `product_category` int(11) DEFAULT NULL,
  `product_artist_id` int(11) DEFAULT NULL,
  `date_added` date DEFAULT NULL,
  `deleted` char(1) DEFAULT 'N',
  `featured` char(1) DEFAULT 'N',
  `vdigital_product` char(1) NOT NULL DEFAULT '',
  `vapproved` char(2) NOT NULL DEFAULT 'N',
  `payment_status` enum('PENDING','COMPLETED') NOT NULL DEFAULT 'PENDING',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


ALTER TABLE multicart_orders ADD vorder_currency VARCHAR( 10 ) NOT NULL ,
ADD taxrate double default '0',
ADD vpayment_status CHAR( 1 ) NOT NULL ;

CREATE TABLE multicart_template_master (
  ntemplate_id int(11) NOT NULL auto_increment,
  vtemplate_name varchar(50) NOT NULL default '',
  vtop_filename varchar(50) NOT NULL default '',
  vleft_filename varchar(50) NOT NULL default '',
  vbottom_filename varchar(50) NOT NULL default '',
  vimages_folder varchar(250) NOT NULL default '',
  vcss_name varchar(100) NOT NULL default '',
  vcss_original varchar(100) NOT NULL default '',
  vactive_status char(1) NOT NULL default '',
  PRIMARY KEY  (ntemplate_id)
) TYPE=MyISAM;

drop table if exists multicart_shipping_settings;

CREATE TABLE multicart_shipping_settings (
  sid tinyint(11) NOT NULL auto_increment,
  nShippingweight int(11) NOT NULL default '0',
  ups_rate varchar(255) NOT NULL default '',
  container_type varchar(255) NOT NULL default '',
  address_quote_method varchar(255) NOT NULL default '',
  PRIMARY KEY  (sid)
) TYPE=MyISAM;

ALTER TABLE multicart_shipping_methods ADD vdeleted CHAR( 1 ) NOT NULL ;

drop table if exists multicart_shipping_details;

CREATE TABLE multicart_shipping_details (
  nshipping_id int(11) NOT NULL auto_increment,
  nshipping_type int(11) NOT NULL default '0',
  norder_id int(11) NOT NULL default '0',
  vshipping_name varchar(250) NOT NULL default '',
  nshipping_cost float NOT NULL default '0',
  nshipping_weight int(11) NOT NULL default '0',
  vshipping_currency varchar(10) NOT NULL default '',
  dshipped_date datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (nshipping_id)
) TYPE=MyISAM;

drop table if exists multicart_rating;

CREATE TABLE multicart_rating (
  nrat_id int(11) NOT NULL auto_increment,
  vrating varchar(50) NOT NULL default '',
  PRIMARY KEY  (nrat_id)
) TYPE=MyISAM;

drop table if exists multicart_record_ratings;

CREATE TABLE multicart_record_ratings (
  nrts_id int(11) NOT NULL auto_increment,
  nrating_id int(11) NOT NULL default '0',
  nruser_id int(11) NOT NULL default '0',
  nrseller_id int(11) NOT NULL default '0',
  ntotal_ratings int(11) NOT NULL default '0',
  PRIMARY KEY  (nrts_id)
) TYPE=MyISAM;

ALTER TABLE multicart_settings ADD nsettings_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST ;

ALTER TABLE multicart_settings ADD vgoogle_check_enable CHAR( 1 ) NOT NULL ,
ADD vgooglecheck_id VARCHAR( 250 ) NOT NULL ,
ADD vgooglecheck_key VARCHAR( 250 ) NOT NULL ,
ADD vgooglecheck_mode VARCHAR( 10 ) NOT NULL ,
ADD vyourpay_enable CHAR( 1 ) NOT NULL ,
ADD vyourpay_storeid VARCHAR( 250 ) NOT NULL ,
ADD vyourpay_certificate_file VARCHAR( 250 ) NOT NULL ,
ADD vyourpay_mode VARCHAR( 5 ) NOT NULL,
CHANGE defaulttax_rate defaulttax_rate FLOAT NULL DEFAULT '0' ;

ALTER TABLE multicart_settings ADD banner_size VARCHAR( 15 ) NOT NULL AFTER site_logo,
ADD npagination_limit INT(11) NOT NULL default '10' AFTER banner_size,
ADD enable_google CHAR( 1 ) NOT NULL AFTER npagination_limit ,
ADD nproduct_images INT NOT NULL AFTER enable_google ,
ADD google_adsense_value TEXT NOT NULL AFTER nproduct_images ,
ADD enable_shipping CHAR( 1 ) NOT NULL AFTER google_adsense_value ,
ADD more_images CHAR( 1 ) NOT NULL AFTER enable_shipping,
ADD site_url varchar(250) default '' After site_name,
ADD site_secure_url varchar(250) default '' After site_url,
ADD enable_tax enum('0','1','2') NOT NULL default '0' After site_secure_url,
ADD enable_flatrate varchar(10) NOT NULL default 'Y' After enable_tax,
ADD default_flatrate float NOT NULL default '20' After enable_flatrate,
ADD additional_flatrate float NOT NULL default '10' After default_flatrate,
ADD defaulttax_rate int(11) default '0' After additional_flatrate,
ADD enable_fedexshipping varchar(10) default 'N' After defaulttax_rate,
ADD enable_uspsshipping varchar(10) NOT NULL default 'N' After enable_fedexshipping,
ADD enable_canadapost varchar(10) NOT NULL default 'N' After enable_uspsshipping,
ADD enable_australiapost varchar(10) NOT NULL default 'N' After enable_canadapost,
ADD canada_merchantId varchar(30) default '' After enable_australiapost,
ADD canada_server varchar(30) default '' After canada_merchantId,
ADD enableworldpay char(1) default '' After canada_server,
ADD worldpay_testmode enum('0','100') NOT NULL default '0' After enableworldpay,
ADD worldpay_inst_Id varchar(15) default '' After worldpay_testmode,
ADD worldpay_email varchar(30) default '' After worldpay_inst_Id,
ADD worldpay_transact_method enum('A','C','E','R') default 'A' After worldpay_email,
ADD approve_sellers enum ('1','2','3') default '1' After  vyourpay_mode,
ADD approve_affiliates enum ('1','2','3') default '1' After  approve_sellers,
ADD approve_products enum ('1','2') default '1' After  approve_affiliates,
ADD enable_rma varchar(10) NOT NULL default 'N' After  approve_products,
ADD rma_repair varchar(10) NOT NULL default 'N' After  enable_rma,
ADD rma_replace varchar(10) NOT NULL default 'N' After  rma_repair,
ADD rma_refund varchar(10) NOT NULL default 'N' After  rma_replace,
ADD rma_confirm_message varchar(10) NOT NULL default 'N' After  rma_refund,
ADD rma_status_change varchar(10) NOT NULL default 'N' After  rma_confirm_message,
ADD enable_bulkupload varchar(10) NOT NULL default 'N' After  rma_status_change ;

ALTER TABLE multicart_artists ADD company varchar(50) default '' After date_registered,
ADD website varchar(30) default '' After company,
ADD vseller_currency  varchar(50) default '' After taxid,
ADD vapproved char(2) default 'N' After website,
ADD defaultflatrate float NOT NULL default '0'  After vapproved,
ADD additionalflatrate float NOT NULL default '0'  After defaultflatrate;

ALTER TABLE multicart_affiliates ADD vapproved char(2) default 'N' After deleted;
 

drop table if exists multicart_fedexsettings;

CREATE TABLE multicart_fedexsettings (
  fid int(11) NOT NULL auto_increment,
  FedexAccno varchar(40) default NULL,
  FedexMeterno varchar(20) default NULL,
  FedexWeight varchar(20) default NULL,
  FedexServer varchar(20) default NULL,
  FedexDropOff varchar(100) default NULL,
  FedexService text,
  FedexPackage varchar(50) default NULL,
  FedexCurrency varchar(10) default NULL,
  PRIMARY KEY  (fid)
) TYPE=MyISAM;

drop table if exists multicart_refunds;
CREATE TABLE multicart_refunds (
  refund_id bigint(20) NOT NULL auto_increment,
  seller_id bigint(20) NOT NULL default '0',
  buyer_id bigint(20) NOT NULL default '0',
  product_id bigint(20) NOT NULL default '0',
  order_id bigint(20) NOT NULL default '0',
  quantity bigint(20) default NULL,
  return_reason text NOT NULL,
  Customer_Feedback text,
  Status varchar(255) default NULL,
  Additional_info text,
  date date NOT NULL default '0000-00-00',
 refund_mode varchar(255) default NULL,
  reference_number varchar(255) default NULL,
  PRIMARY KEY  (`refund_id`)
) TYPE=MyISAM;


drop table if exists multicart_usps_settings;

CREATE TABLE multicart_usps_settings (
  id int(11) NOT NULL auto_increment,
  username varchar(40) NOT NULL default '',
  server varchar(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


drop table if exists multicart_taxrate;

CREATE TABLE multicart_taxrate(
  Tid int(20) NOT NULL auto_increment,
  taxname varchar(255) default NULL,
  vtaxbase varchar(40) default NULL,
  vCountry varchar(255) default NULL,
  vState text,
  ntaxrate float NOT NULL default '0',
  vtaxaddress enum('shipping','billing') NOT NULL default 'shipping',
  rate_enable enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (Tid)
) TYPE=MyISAM;
drop table if exists multicart_digital_product;

CREATE TABLE multicart_digital_product (
  ndigital_id int(11) NOT NULL auto_increment,
  vdigital_product_name varchar(250) NOT NULL default '',
  ndigital_productid int(11) NOT NULL default '0',
  ndigital_orderid int(11) NOT NULL default '0',
  vdigital_product_code text NOT NULL,
  ndownload_try int(11) NOT NULL default '0',
  ndownload_count int(11) NOT NULL default '0',
  ndownload_expiry datetime NOT NULL default '0000-00-00 00:00:00',
  ndownload_status int(11) NOT NULL default '0',
  PRIMARY KEY  (ndigital_id)
) TYPE=MyISAM;

drop table if exists multicart_product_view_images;

CREATE TABLE multicart_product_view_images (
  nproduct_image_id int(11) NOT NULL auto_increment,
  nimage_productid int(11) NOT NULL default '0',
  vimage_name varchar(250) NOT NULL default '',
  vproduct_image_delete_status char(1) NOT NULL default '',
  PRIMARY KEY  (nproduct_image_id)
) TYPE=MyISAM;

ALTER TABLE multicart_product_view_images ADD vimage_description TEXT NOT NULL AFTER vimage_name ;

drop table if exists multicart_report_product;

CREATE TABLE multicart_report_product (
  nreport_id int(11) NOT NULL auto_increment,
  nreport_product_id int(11) NOT NULL default '0',
  nreport_customerid int(11) NOT NULL default '0',
  nproduct_view_count int(11) NOT NULL default '0',
  dproduct_view_date date NOT NULL default '0000-00-00',
  PRIMARY KEY  (nreport_id)
) TYPE=MyISAM;

drop table if exists multicart_affiliate_banner;

CREATE TABLE multicart_affiliate_banner (
naff_banner_id INT NOT NULL AUTO_INCREMENT ,
vaff_banner_name VARCHAR( 250 ) NOT NULL ,
PRIMARY KEY ( naff_banner_id )
) TYPE = MYISAM ;

drop table if exists multicart_cart_temp;

CREATE TABLE multicart_cart_temp (
ncart_temp_id INT NOT NULL AUTO_INCREMENT ,
ncart_id INT NOT NULL ,
ncart_quantity INT NOT NULL ,
PRIMARY KEY ( ncart_temp_id )
) TYPE = MYISAM ;

ALTER TABLE multicart_settings ADD ndisplay_stock CHAR( 1 ) NOT NULL AFTER more_images ;

ALTER TABLE multicart_settings ADD ndisplay_banner CHAR( 1 ) NOT NULL AFTER ndisplay_stock ;

ALTER TABLE multicart_settings ADD vauthorize_enable CHAR( 1 ) NOT NULL AFTER referral_charge ;

ALTER TABLE multicart_digital_product ADD ndownload_expiry_days INT NOT NULL AFTER ndownload_expiry ;

ALTER TABLE multicart_settings ADD venable_gift_payment CHAR( 1 ) NOT NULL AFTER referral_charge ;

drop table if exists multicart_content_management;

CREATE TABLE multicart_content_management (
content_id INT NOT NULL AUTO_INCREMENT ,
content_name VARCHAR( 25 ) NOT NULL ,
content_heading VARCHAR( 50 ) NOT NULL ,
content_text TEXT NOT NULL ,
PRIMARY KEY ( content_id )
) TYPE = MYISAM ;

ALTER TABLE multicart_content_management CHANGE content_heading content_heading TEXT ;

drop table if exists multicart_email_templates;

CREATE TABLE multicart_email_templates (
nemail_id INT NOT NULL AUTO_INCREMENT ,
vemail_body TEXT NOT NULL ,
vreplaceable_variables TEXT NOT NULL ,
PRIMARY KEY ( nemail_id )
) TYPE = MYISAM ; 

ALTER TABLE multicart_email_templates ADD vtemplate_name VARCHAR( 100 ) NOT NULL AFTER nemail_id ;
ALTER TABLE multicart_email_templates ADD vtemplate_title VARCHAR( 100 ) NOT NULL AFTER nemail_id ;
ALTER TABLE multicart_email_templates ADD vtemplate_flag CHAR( 1 ) NOT NULL ;

ALTER TABLE multicart_giftcoupon_master ADD ngift_order_id INT NOT NULL AFTER ngift_product_id ;

ALTER TABLE multicart_affiliate_registrations ADD vaffiliate_currency VARCHAR( 10 ) NOT NULL AFTER registration_id ;


ALTER TABLE multicart_shipping_details ADD nshp_productid INT NOT NULL AFTER norder_id ;
ALTER TABLE multicart_shipping_details ADD nshp_status CHAR( 1 ) NOT NULL ;

drop table if exists multicart_Review;
CREATE TABLE multicart_Review (
nRId INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
nUserId INT NOT NULL DEFAULT '0',
nProdId INT NOT NULL DEFAULT '0',
vDes TEXT NOT NULL ,
vActive ENUM( '0', '1' ) NOT NULL DEFAULT '0'
) ENGINE = MYISAM;

ALTER TABLE multicart_record_ratings ADD vType CHAR( 1 ) NOT NULL DEFAULT 's' AFTER ntotal_ratings,
   ADD vActive ENUM( '0', '1' ) NOT NULL DEFAULT '1' AFTER vType;

ALTER TABLE multicart_settings ADD vReview CHAR( 9 ) NOT NULL DEFAULT 'automatic' AFTER site_logo;


drop table if exists multicart_newsletters;

CREATE TABLE multicart_newsletters (
  nl_id int(11) NOT NULL auto_increment,
  nl_subject varchar(200) NOT NULL default '',
  nl_message text NOT NULL,
  nl_date timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (nl_id),
  UNIQUE KEY nl_id (nl_id)
) ENGINE = MyISAM;


drop table if exists multicart_Subscribers;

CREATE TABLE multicart_Subscribers (
  nl_subscribersID int(11) NOT NULL auto_increment,
  user_id int(11) NOT NULL default '0',
  nl_id int(11) NOT NULL default '0',
  PRIMARY KEY  (nl_subscribersID),
  UNIQUE KEY nl_subscribersID (nl_subscribersID)
) ENGINE=MyISAM;


drop table if exists multicart_couponCode;

CREATE TABLE multicart_couponCode (
  ccID int(11) NOT NULL auto_increment,
  ccStartDate date NOT NULL default '0000-00-00',
  ccEndDate date NOT NULL default '0000-00-00',
  ccCode varchar(50) NOT NULL default '',
  ccDescription text NOT NULL,
  ccDiscount int(11) NOT NULL default '0',
  subscriptionStatus char(1) NOT NULL default '',
  ccStatus char(1) NOT NULL default '',
  PRIMARY KEY  (ccID),
  UNIQUE KEY ccCode (ccCode)
) ENGINE=MyISAM;


drop table if exists multicart_sellerPlans;

CREATE TABLE multicart_sellerPlans (
  plan_Id int(11) NOT NULL auto_increment,
  plan_Title varchar(100) NOT NULL default '',
  plan_Description text NOT NULL,
  plan_Period char(1) NOT NULL default '',
  plan_SubscriptionCharge double NOT NULL default '0',
  plan_Status char(1) NOT NULL default '',
  PRIMARY KEY  (plan_Id)
) ENGINE=MyISAM;


drop table if exists multicart_artists_membershipDetails;

CREATE TABLE multicart_artists_membershipDetails (
  artist_memID int(11) NOT NULL auto_increment,
  artist_id int(11) NOT NULL default '0',
  artist_memStartDate date NOT NULL default '0000-00-00',
  artist_memEndDate date NOT NULL default '0000-00-00',
  plan_Id int(11) NOT NULL default '0',
  plan_SubscriptionCharge double NOT NULL default '0',
  PRIMARY KEY  (artist_memID)
) ENGINE=MyISAM;
        


ALTER TABLE multicart_orders ADD couponCode varchar(50)  NOT NULL DEFAULT '0' AFTER taxrate;
ALTER TABLE multicart_orders ADD couponCodeDiscount int(11) NOT NULL DEFAULT '0' AFTER couponCode;


ALTER TABLE multicart_settings ADD venable_couponCode_payment char(1) NOT NULL DEFAULT 'N' AFTER venable_gift_payment;
ALTER TABLE multicart_settings ADD enable_buyerToseller char(1) NOT NULL DEFAULT 'N' AFTER venable_couponCode_payment;
ALTER TABLE multicart_settings ADD enable_membership char(1) NOT NULL DEFAULT 'N' AFTER enable_buyerToseller;


ALTER TABLE multicart_artists ADD sellerPlanID int(11) NOT NULL  AFTER additionalflatrate;
ALTER TABLE multicart_artists ADD enablepaypal char(1) NOT NULL   DEFAULT '' AFTER sellerPlanID;
ALTER TABLE multicart_artists ADD enablepaypalsandbox char(1) NOT NULL DEFAULT '' AFTER enablepaypal;
ALTER TABLE multicart_artists ADD paypalidentitytoken varchar(200) NOT NULL DEFAULT '' AFTER enablepaypalsandbox;
ALTER TABLE multicart_artists ADD paypalemail varchar(100) NOT NULL DEFAULT '' AFTER paypalidentitytoken;


ALTER TABLE `multicart_orders` ADD `transaction_id` VARCHAR( 255 ) ;
ALTER TABLE `multicart_shipping_details` ADD `user_id` INT( 11 ) NOT NULL DEFAULT '0';
ALTER TABLE `multicart_artist_payments` ADD `payment_status` ENUM( 'P', 'C' ) NOT NULL DEFAULT 'P';
ALTER TABLE `multicart_settings` ADD `flatrate_displayname` VARCHAR( 255 ) NOT NULL DEFAULT 'Over night ground';

ALTER TABLE `multicart_artists` ADD `plan_expired` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'N' COMMENT 'Whether plan expired or not';

ALTER TABLE `multicart_artists_membershipDetails` ADD `transaction_id` VARCHAR( 255 ) NOT NULL ;


ALTER TABLE `multicart_order_details` ADD `item_delivery_date` DATETIME NOT NULL ;


CREATE TABLE IF NOT EXISTS `multicart_metatags` (
  `nId` int(11) NOT NULL auto_increment,
  `vTitle` varchar(200) default NULL,
  `vKeywords` text,
  `vDescription` text,
  `vPageName` varchar(20) default NULL,
  PRIMARY KEY  (`nId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


ALTER TABLE `multicart_artists` 
	CHANGE `sellerPlanID` `sellerPlanID` int(11)   NOT NULL DEFAULT '0' after `additionalflatrate`, 
	CHANGE `plan_expired` `plan_expired` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' COMMENT 'Whether \r\n\r\nplan expired or not' after `paypalemail`;

ALTER TABLE `multicart_cart` 
	ADD COLUMN `product_option_id` bigint(20)   NOT NULL after `product_id`, 
	CHANGE `quantity` `quantity` int(11)   NULL after `product_option_id`, 
	CHANGE `status` `status` tinyint(4)   NULL after `quantity`, 
	CHANGE `datetime_added` `datetime_added` varchar(20)  COLLATE latin1_swedish_ci NULL after `status`;


ALTER TABLE `multicart_categories` 
	ADD COLUMN `avatar` varchar(250)  COLLATE latin1_swedish_ci NOT NULL after `gift_certificate_flag`;

CREATE TABLE `multicart_category_options`(
	`category_option_id` bigint(20) NOT NULL  auto_increment , 
	`category_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`category_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_couponcode` 
	CHANGE `ccDiscount` `ccDiscount` int(11)   NOT NULL DEFAULT '0' after `ccDescription`;

CREATE TABLE `multicart_email_templates_back`(
	`nemail_id` int(11) NOT NULL  auto_increment , 
	`vtemplate_name` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vtemplate_title` varchar(100) COLLATE latin1_swedish_ci NOT NULL  DEFAULT '' , 
	`vemail_body` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vreplaceable_variables` text COLLATE latin1_swedish_ci NOT NULL  , 
	`vtemplate_flag` char(1) COLLATE latin1_swedish_ci NULL  DEFAULT '' , 
	PRIMARY KEY (`nemail_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_default`(
	`flat_rate_default_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	PRIMARY KEY (`flat_rate_default_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_flat_rate_seller`(
	`flat_rate_seller_id` bigint(20) NOT NULL  auto_increment , 
	`flat_rate_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`first_Item_charge` float NOT NULL  , 
	`additional_Item_charge` float NOT NULL  , 
	`seller_id` bigint(20) NOT NULL  , 
	PRIMARY KEY (`flat_rate_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_help`(
	`hid` int(11) NOT NULL  auto_increment , 
	`hcid` int(11) NULL  , 
	`htitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hdescription` text COLLATE latin1_swedish_ci NULL  , 
	`hposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	`himage` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_helpcategory`(
	`hcid` int(11) NOT NULL  auto_increment , 
	`htype` varchar(10) COLLATE latin1_swedish_ci NULL  , 
	`hctitle` varchar(100) COLLATE latin1_swedish_ci NULL  , 
	`hcposition` int(11) NULL  , 
	`active` enum('0','1') COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`hcid`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_homepagebanners`(
	`homepage_banner_id` bigint(20) NOT NULL  auto_increment , 
	`image` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`deleted` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`homepage_banner_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_message_to_seller`(
	`message_to_seller_id` bigint(20) NOT NULL  auto_increment , 
	`artist_id` int(11) NOT NULL  , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`email` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`subject` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`message` text COLLATE latin1_swedish_ci NOT NULL  , 
	`created_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`read` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'N' , 
	PRIMARY KEY (`message_to_seller_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_metatags`(
	`nId` int(11) NOT NULL  auto_increment , 
	`vTitle` varchar(200) COLLATE latin1_swedish_ci NULL  , 
	`vKeywords` text COLLATE latin1_swedish_ci NULL  , 
	`vDescription` text COLLATE latin1_swedish_ci NULL  , 
	`vPageName` varchar(20) COLLATE latin1_swedish_ci NULL  , 
	PRIMARY KEY (`nId`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_options`(
	`option_id` bigint(20) NOT NULL  auto_increment , 
	`option_name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_order_details` 
	ADD COLUMN `product_option_id` int(11)   NOT NULL after `product_id`, 
	CHANGE `product_name` `product_name` varchar(200)  COLLATE latin1_swedish_ci NULL after `product_option_id`, 
	CHANGE `product_code` `product_code` varchar(20)  COLLATE latin1_swedish_ci NULL after `product_name`, 
	CHANGE `product_price` `product_price` double   NULL after `product_code`, 
	ADD COLUMN `product_tax` float   NOT NULL after `product_price`, 
	CHANGE `product_quantity` `product_quantity` int(11)   NULL after `product_tax`, 
	CHANGE `artist_id` `artist_id` bigint(20)   NULL after `product_quantity`, 
	CHANGE `item_status` `item_status` smallint(6)   NULL after `artist_id`, 
	CHANGE `artist_payment_status` `artist_payment_status` smallint(6)   NULL after `item_status`, 
	CHANGE `artist_payment_id` `artist_payment_id` bigint(20)   NULL after `artist_payment_status`, 
	CHANGE `user_refund_id` `user_refund_id` bigint(20)   NULL DEFAULT '0' after `artist_payment_id`, 
	CHANGE `product_discount` `product_discount` int(11)   NULL DEFAULT '0' after `user_refund_id`, 
	CHANGE `item_delivery_date` `item_delivery_date` datetime   NOT NULL after `product_discount`, 
	ADD COLUMN `product_commission_amount` float   NOT NULL DEFAULT '0' after `item_delivery_date`;

ALTER TABLE `multicart_orders` 
	CHANGE `vgiftcertificate_code` `vgiftcertificate_code` varchar(255)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `transaction_id`, 
	CHANGE `nused_gift_amount` `nused_gift_amount` double   NOT NULL DEFAULT '0' after `vgiftcertificate_code`, 
	CHANGE `namount_paid` `namount_paid` double   NOT NULL DEFAULT '0' after `nused_gift_amount`, 
	ADD COLUMN `buyer_comments` text  COLLATE latin1_swedish_ci NOT NULL after `namount_paid`;

CREATE TABLE `multicart_product_impression`(
	`product_impression_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`ip` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`visited_on` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	PRIMARY KEY (`product_impression_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_listing_fee_payment`(
	`product_listing_fee_payment_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`total_amount` int(11) NOT NULL  , 
	`amount_paid` int(11) NOT NULL  , 
	`payment_method` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`payment_date` timestamp NOT NULL  DEFAULT CURRENT_TIMESTAMP , 
	`payment_status` enum('PENDING','COMPLETED') COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_listing_fee_payment_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_option_values`(
	`product_option_value_id` bigint(20) NOT NULL  auto_increment , 
	`product_option_id` bigint(20) NOT NULL  , 
	`option_id` bigint(20) NOT NULL  , 
	`value` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	PRIMARY KEY (`product_option_value_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


CREATE TABLE `multicart_product_options`(
	`product_option_id` bigint(20) NOT NULL  auto_increment , 
	`product_id` bigint(20) NOT NULL  , 
	`additional_price` float NOT NULL  , 
	`image_small` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`image_big` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_stock` int(11) NOT NULL  , 
	`reorder_level` int(11) NOT NULL  , 
	`product_shipping_weight` float NOT NULL  , 
	`default_option` enum('YES','NO') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'YES' , 
	`discount` float NOT NULL  , 
	`discount_description` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`product_width` int(11) NOT NULL  , 
	`product_height` int(11) NOT NULL  , 
	`product_length` int(11) NOT NULL  , 
	PRIMARY KEY (`product_option_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';


ALTER TABLE `multicart_products` 
	CHANGE `product_category` `product_category` int(11)   NULL after `product_price`, 
	CHANGE `product_artist_id` `product_artist_id` int(11)   NULL after `product_category`, 
	CHANGE `date_added` `date_added` date   NULL after `product_artist_id`, 
	CHANGE `deleted` `deleted` char(1)  COLLATE latin1_swedish_ci NULL DEFAULT 'N' after `date_added`, 
	CHANGE `featured` `featured` char(1)  COLLATE latin1_swedish_ci NULL DEFAULT 'N' after `deleted`, 
	CHANGE `vdigital_product` `vdigital_product` char(1)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `featured`, 
	CHANGE `vapproved` `vapproved` char(2)  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `vdigital_product`, 
	ADD COLUMN `payment_status` enum('PENDING','COMPLETED')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'PENDING' after `vapproved`, 
	DROP COLUMN `product_height`, 
	DROP COLUMN `product_width`, 
	DROP COLUMN `product_length`, 
	DROP COLUMN `product_image_small`, 
	DROP COLUMN `product_image_big`, 
	DROP COLUMN `product_stock`, 
	DROP COLUMN `reorder_level`, 
	DROP COLUMN `discount`, 
	DROP COLUMN `discountdescription`, 
	DROP COLUMN `nproduct_shipping_weight`;

ALTER TABLE `multicart_settings` 
	CHANGE `vReview` `vReview` varchar(9)  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'automatic' after `site_logo`, 
	ADD COLUMN `enable_multicurrency` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `site_logo`, 
	ADD COLUMN `slideshow_delay` int(5)   NOT NULL after `enable_multicurrency`, 
	ADD COLUMN `enable_affiliates` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'Y' after `slideshow_delay`, 
	ADD COLUMN `more_image_limit` int(11)   NOT NULL after `enable_affiliates`, 
	ADD COLUMN `vyourpay_userid` varchar(100)  COLLATE latin1_swedish_ci NOT NULL after `more_image_limit`, 
	ADD COLUMN `paypal_api_username` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `vyourpay_userid`, 
	ADD COLUMN `paypal_api_password` varchar(200)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_username`, 
	ADD COLUMN `paypal_api_signature` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_password`, 
	ADD COLUMN `paypal_application_app_id` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `paypal_api_signature`, 
	ADD COLUMN `product_listing_fee` int(11)   NOT NULL after `paypal_application_app_id`, 
	ADD COLUMN `enable_commentbox` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `product_listing_fee`, 
	ADD COLUMN `vbluepay_enable` enum('Y','N')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'N' after `enable_commentbox`, 
	ADD COLUMN `bluepay_accountid` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `vbluepay_enable`, 
	ADD COLUMN `bluepay_secretkey` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `bluepay_accountid`, 
	ADD COLUMN `bluepay_test_mode` enum('TEST','LIVE')  COLLATE latin1_swedish_ci NOT NULL DEFAULT 'TEST' after `bluepay_secretkey`;

ALTER TABLE `multicart_shipping_details` 
	ADD COLUMN `nproduct_option_id` int(11)   NOT NULL after `nshp_productid`, 
	ADD COLUMN `nshp_productname` varchar(255)  COLLATE latin1_swedish_ci NOT NULL after `nproduct_option_id`, 
	CHANGE `vshipping_name` `vshipping_name` varchar(250)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshp_productname`, 
	CHANGE `nshipping_cost` `nshipping_cost` float   NOT NULL DEFAULT '0' after `vshipping_name`, 
	CHANGE `nshipping_weight` `nshipping_weight` int(11)   NOT NULL DEFAULT '0' after `nshipping_cost`, 
	CHANGE `vshipping_currency` `vshipping_currency` varchar(10)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `nshipping_weight`, 
	CHANGE `dshipped_date` `dshipped_date` datetime   NOT NULL DEFAULT '0000-00-00 00:00:00' after `vshipping_currency`, 
	CHANGE `nshp_status` `nshp_status` char(1)  COLLATE latin1_swedish_ci NOT NULL DEFAULT '' after `dshipped_date`, 
	CHANGE `user_id` `user_id` bigint(11)   NOT NULL DEFAULT '0' after `nshp_status`;

CREATE TABLE `multicart_social_media`(
	`social_media_id` int(11) NOT NULL  auto_increment , 
	`name` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`title` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`link` text COLLATE latin1_swedish_ci NOT NULL  , 
	`logo` varchar(250) COLLATE latin1_swedish_ci NOT NULL  , 
	`active` enum('Y','N') COLLATE latin1_swedish_ci NOT NULL  DEFAULT 'Y' , 
	PRIMARY KEY (`social_media_id`) 
) ENGINE=MyISAM DEFAULT CHARSET='latin1';

ALTER TABLE `multicart_artist_payments` ADD `seller_order_total_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `commission_percentage` ,ADD `admin_commision_amount` DOUBLE NOT NULL DEFAULT '0' AFTER `seller_order_total_amount` ;

ALTER TABLE `multicart_fedexsettings`
	ADD COLUMN `FedexPassword` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexCurrency`,
	ADD COLUMN `FedexKey` VARCHAR(50) NULL DEFAULT NULL AFTER `FedexPassword`;