<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts Multicart                     |
// +----------------------------------------------------------------------+
// | Authors: Santhosh Thomas Alexander<santhosh.thomas@armiasystems.com> |
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems, Inc and iScripts.com ï¿½ 2005                |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.  addtowishlish_btn                                                     |
// +----------------------------------------------------------------------+
include "includes/config.php";
include "includes/session.php";
include "includes/functions.php";
include_once "classes/cls_user.php";
include_once "classes/cls_products.php";
include_once "classes/cls_subscription.php";
include_once "classes/cls_store.php";
if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
    $_POST = array_map('stripslashes_deep', $_POST);
    $_GET = array_map('stripslashes_deep', $_GET);
    $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

// Get Product ID from Alias
if (isset($_GET["productid"]) and $_GET["productid"] != "") {
    $productID = $_GET["productid"];
} else if (isset($_POST["productid"]) and $_POST["productid"] != "") {
    $productID = $_POST["productid"];
}

//************************************Multicart 3.0 Additions*******************************

// End check subscription

$addTocartFlag  =   'Y';
$productAlias = end(explode("/",$_SERVER['REQUEST_URI']));
$arrProductid = DbHelper::getResult('products','product_id',"alias = '$productAlias'");
if(!empty($arrProductid)) {
    $productidFromAlias = $arrProductid[0]->product_id;
    $productid = ($productidFromAlias!= NULL)?$productidFromAlias:$productID;
}else{
     header("Location:".SITE_URL."/404.php");
     exit;
}
// Get Product ID from Alias
//Check Subscription Status of products
if($productid!='') {
  
$subscriptionStatusObj      =   Products::get_product_subscription_deatils($productid);
//echopre($subscriptionStatusObj);
if($subscriptionStatusObj->status==SUCCESS)
        {
               $subscriptionFlag        =   'N';
               $subscriptionObjVals     =   $subscriptionStatusObj->data;
               $subscriptionFlag        =   $subscriptionObjVals->allow_subscription;
               $subscriptionMode        =   $subscriptionObjVals->subscription_mode;
               $subscription_seller_id  =   $subscriptionObjVals->product_artist_id;
                switch ($subscriptionMode) {
                    case "Daily":
                            $subscriptionMode_Text      = SUBSCRIPTION_DAILY_TEXT;
                            $subscriptionDuration_Text  = SUBSCRIPTION_DURATION_DAY_TEXT;

                        break;
                    case "Monthly":
                            $subscriptionMode_Text      = SUBSCRIPTION_MONTHLY_TEXT;
                            $subscriptionDuration_Text  = SUBSCRIPTION_DURATION_MONTH_TEXT;
                        break;
                    case "Yearly":
                            $subscriptionMode_Text      = SUBSCRIPTION_YEARLY_TEXT;
                            $subscriptionDuration_Text  = SUBSCRIPTION_DURATION_YEAR_TEXT;
                        break;

                    default:
                        break;
                }

        
            // Check  whether the  items is added by  same seller , then hide the addto cart , subscription buttons //  Valid for single account for buyer and seller
                $addTofavoritesFlag         =   'Y';
                 if($_SESSION["sess_userid"]!='')  {
                            //Check the product is logged users product
                            $sellerAccObj   =    User::is_seller_account_activated($_SESSION["sess_userid"]);
                                  //echopre($sellerAccObj);
                            if($sellerAccObj->status==SUCCESS)
                                {
                                        $sellerAccObjVal            =   $sellerAccObj->data;
                                        $seller_activated_status    =   $sellerAccObjVal->is_seller;
                                        $activated_seller_id        =   $sellerAccObjVal->seller_id;
                                        
                                 // Cross check the seller account valid and exists       
                                    $sellerObj  =    Store::get_seller_account_info($activated_seller_id);
                                    if($sellerObj->status==SUCCESS)
                                    {
                                       $sellerObjVal                       =   $sellerObj->data;
                                       $product_seller_id                  =   $sellerObjVal->artist_id;  
                                    }
                                        if($product_seller_id==$subscription_seller_id)
                                            {
                                                   $subscriptionFlag                =   'N';
                                                   $addTocartFlag                   =   'N';
                                                   $addTofavoritesFlag              =   'N';
                                            }
                                }
                        }
      // End Subscription check status
              
        }
}   

//*****************************************Multicart3.0 Additions**********************************

/*
 * Impression counter by Binu Chandran.E
 */
$impressionFound = false;
//Client IP Address
$ip = getClientIP();
//Check last visit for this product from same Ip address
//With in 24 hrs
$imQuery = "SELECT product_impression_id
              FROM " . $tableprefix . "product_impression
             WHERE product_id = '" . mysql_real_escape_string($productid) . "'
               AND ip = '" . mysql_real_escape_string($ip) . "'
               AND ADDDATE(visited_on, INTERVAL 24 HOUR) > NOW()";
$result = mysql_query($imQuery) or die(mysql_error());
if (mysql_num_rows($result) > 0) {
    $imRow = mysql_fetch_object($result);
    if ($imRow->product_impression_id > 0) {
        $impressionFound = true;
    }
}

if ($impressionFound === false) {
    //Add new visit
    $imQuery = "INSERT INTO " . $tableprefix . "product_impression
             SET product_id = '" . mysql_real_escape_string($productid) . "',
                ip = '" . mysql_real_escape_string($ip) . "'";
    mysql_query($imQuery) or die(mysql_error());
}

/*
 * Impression counter - End here
 */


/* -----------Multicart 2.0 Upgradation------------ */

$check_shipping_enable = checkShippingEnable();

$prodimagedir = "products/";


 $sql = "SELECT
        p.product_id,p.product_name,p.product_description,p.product_name,p.product_code,
        po.product_option_id,po.image_small,po.image_big,po.product_stock,(p.product_price + po.additional_price) AS product_price,
        po.discount,po.discount_description,po.product_shipping_weight,p.product_tags,
        ar.company,ar.storename,ap.artist_photo,ar.state,ar.city,ar.country,ar.artist_name,ar.first_name,ar.last_name,ar.artist_id,ap.artist_description,c.category_id,
        (SELECT pm.vimage_name FROM ".$tableprefix."product_view_images pm where pm.nimage_productid=p.product_id LIMIT 0,1)AS smallimage
        FROM " . $tableprefix . "products p
        INNER JOIN " . $tableprefix . "product_options po ON po.product_id = p.product_id AND po.default_option = 'YES'
        INNER JOIN  " . $tableprefix . "artists ar ON ar.artist_id = p.product_artist_id
        INNER JOIN  " . $tableprefix . "categories  c ON c.category_id = p.product_category
        LEFT JOIN " . $tableprefix . "artist_portfolios ap ON ar.artist_id = ap.artist_id
        WHERE p.product_id = '" . addslashes($productid) . "' AND ar.plan_expired = 'N'";
 


// Select More Images
$sql_im = "select vimage_name from " . $tableprefix . "product_view_images  where nimage_productid ='" . mysql_real_escape_string($productid) . "' ";
$result_im = mysql_query($sql_im) or die(mysql_error());
$numrows = mysql_num_rows($result_im);


$product_number = mysql_num_rows(mysql_query($sql));
$sess_back = $_SERVER["PHP_SELF"] . "?begin=" . $begin . "&num=" . $num . "&numBegin=" . $numBegin . "&cmbSearchType=" . $cmbSearchType . "&txtSearch=" . $txtSearch . "&catid=" . $catid;
//$_SESSION["gbackurl"] = $sess_back;
$rs = mysql_query($sql);
if (mysql_num_rows($rs) != 0) {
    $prow = mysql_fetch_array($rs);
    $artistid = $prow["artist_id"];
    //$productid  =   $prow['product_id'];
}
// Product Review Listings




$sql_review = " SELECT r.*,u.first_name,u.last_name,p.product_name FROM " . $tableprefix . "Review r LEFT JOIN " . $tableprefix . "users u ON r.nUserId=u.user_id
					LEFT JOIN " . $tableprefix . "products p ON r.nProdId=p.product_id WHERE r.nProdId='" . mysql_real_escape_string($productid) . "' AND r.vActive='1' ORDER BY r.nRId DESC LIMIT 0,5 ";

$rs_review = mysql_query($sql_review) or die(mysql_error());

$ProductReviewCount = mysql_num_rows($rs_review);

if ($ProductReviewCount > 0) {

    $showProductReviewMoreLink = ' &nbsp;<a href=' . SITE_URL . '/product_review_lists.php?pid=' . $productid . '&pname=' . stripslashes($prow['product_name']) . '>' . PRODUCT_REVIEW_LIST_TEXT . ' </a>';
} else {
    $showProductReviewMoreLink = '';
}

// Select Seller Feedback

$sql_seller_feedback = " SELECT f.*, u.first_name,u.last_name  FROM " . $tableprefix . "artist_feedbacks f
		INNER JOIN " . $tableprefix . "users u ON f.user_id = u.user_id
		WHERE f.artist_id = '" . addslashes($prow['artist_id']) . "' AND f.published='Y' order by date_added DESC  LIMIT 5   ";

$rs_seller_feedback = mysql_query($sql_seller_feedback) or die(mysql_error());

$totalsellerFeedbackRows = mysql_num_rows($rs_seller_feedback);
// End
// Fetching Product Details

        if (!is_file("products/" . $prow["image_small"]) && strpos($prow["image_big"], "http") === false) { 
            $product_image = SITE_URL . "/products/noimage.jpg";
            $product_thumb_image = "noimage.jpg";
        } 

        else if (!is_file("products/" . $prow["image_big"]) && strpos($prow["image_big"], "http") === false) { 
            $product_image = SITE_URL . "/products/noimage.jpg";
            $product_thumb_image = "noimage.jpg";
        }
        else if (($prow["image_big"] != "")) { 
            $product_image = $prow["image_big"];
            if (strpos($product_image, "http") === false) {
                if(ENABLE_AMAZON_S3_IMAGES == "Y"){
                $product_image = AMAZON_S3_DOMAIN_URL.$prodimagedir.$product_image ;
                $product_thumb_image = AMAZON_S3_DOMAIN_URL.$prodimagedir.$product_image;
                }else{
                     $product_image = SITE_URL . "/products/" . $product_image;
                     $product_thumb_image = $prow["image_big"];
                }
            } else {
                    $product_image = $product_image;
                    $product_thumb_image = $prow["image_big"];
            }

         }
    
//echo $product_thumb_image;
  $imageurl = "<img  src='" . $product_image . "' border='0' id='itemImage' onClick=PopWinbig('" . $product_image . "','MoreImages','width=400,height=400,resizable=1,scrollbars=1,toolbar=0,status=1'); style='cursor: pointer;'>";
  


if (intval($prow["product_stock"]) > 0) {
    $productinstock = true;
} else {
    $productinstock = false;
}
$artistname = getArtistName($artistid);
// End Details


/* $currency_attributes = displayCurrencyType();
  $conversionRate	= ConvertedCurrencyRate($currency_attributes[2]);
  $converted_price = $prow["product_price"] * $conversionRate;

  $display_product_price = $currency_attributes[0]."&nbsp;".number_format($converted_price,2,".",""); */


$price = $prow["product_price"];

$currency_attributes = displayCurrencyType();
$conversionRate = ConvertedCurrencyRate($currency_attributes[2]);
$converted_price = $price * $conversionRate;
$discountprice = 0;
if ($prow["discount"] != "0") {
    $discountprice = $converted_price - ($converted_price * $prow["discount"]) / 100;
    $discountprice = number_format($discountprice, 2, ".", "");
}


$display_product_price = number_format($converted_price, 2, ".", "");
// End Set Currency Value
// Item Description

$product_description_format = $prow["product_description"];
// End Item Description
// Setting Referer
if (strstr(basename($_SERVER['HTTP_REFERER']), "categorydetail.php") || strstr(basename($_SERVER['HTTP_REFERER']), "index.php")) {
    /* if (function_exists('session_unregister')) {
      (isset($_SESSION['SESS_url_back'])) ? session_unregister('SESS_url_back') : session_register('SESS_url_back');
      }//end if */

    $_SESSION['SESS_url_back'] = basename($_SERVER['HTTP_REFERER']);
}

// End Setting Reffer

$check_array = array('more_images', 'ndisplay_stock');
$settings = getSiteGeneralSettings($check_array);


// Disply Sller Rating Details
$showSellerRating = '';
$showProductReviewLink = '';

if(isset($_GET['productid']))
    {
   // $productid  =   $_GET['productid'];
}
//checking logged user buy the product atleast one
$prodStatus = mysql_query("select od.product_name from " . $tableprefix . "orders o left join " . $tableprefix . "order_details od
							on o.order_id=od.order_id where user_id='" . $_SESSION["sess_userid"] . "' and
							product_id='" . mysql_real_escape_string($productid) . "'") or die(mysql_error());
if (mysql_num_rows($prodStatus) > 0) {

    $pReviewsql = mysql_query("select *  from " . $tableprefix . "Review where nUserId='" . $_SESSION["sess_userid"] . "' and nProdId='" . mysql_real_escape_string($productid) . "'") or die(mysql_error());

    $numRowsReview = mysql_num_rows($pReviewsql);
    if ($numRowsReview <= 0) {
        $showProductReviewLink = '<a href="#" class="review" data-toggle="modal" >' . POST_PRODUCT_REVIEW_TEXT . '</a>';
    }


    $showSellerRating = "<br><a style='cursor:pointer' onClick=";
    $showSellerRating.='"javascript:';
    $showSellerRating.="window.open('seller_rating.php?artist_id=" . $artistid . "', 'SellerRating','menubar=0,resizable=0,width=250,height=200');";
    $showSellerRating.='">Seller Rating</a>';



    $showProductReview = "&nbsp;&nbsp;|&nbsp;&nbsp;<a style='cursor:pointer' onClick=";
    $showProductReview.='"javascript:';
    $showProductReview.="window.open('product_review.php?pid=" . $productid . "', 'SellerRating','menubar=0,resizable=0,width=450,height=300');";
    $showProductReview.='">Post Product Review</a>';

    $showSellerRating = $showSellerRating . $showProductRating . $showProductReview . '&nbsp;&nbsp;|&nbsp;&nbsp;<a href="product_review_lists.php?pid=' . $productid . '&pname=' . $prow["product_name"] . '">Product Review Listings</a>';
}//end if
else {
    $showSellerRating = '&nbsp;&nbsp;|&nbsp;&nbsp;<a href="product_review_lists.php?pid=' . $productid . '&pname=' . $prow["product_name"] . '">Product Review Listings</a>';
    $showSellerRating2 = '&nbsp;&nbsp;|&nbsp;&nbsp;<a href="product_review_lists.php?pid=' . $productid . '&pname=' . $prow["product_name"] . '">Product Review Listings</a>';
}//end else
// End Seller rating Details


/* Report to display the number of times each product viewed */

if ($_SESSION["sess_userid"] != "") {
    productViewedReport(GetSQLValueString($productid, "text"), $_SESSION["sess_userid"]);
}

//Digital Product Flag Check
$digitalFlag = isDigital($productid);

/* display the active template */

//Free Shipping Flag Check

$freeship_flag_text    =   Products::check_free_ship_product_text($productid);

$freeshipObj    =   Products::is_free_ship_product($productid);
       
       //echopre($freeshipObj);
       
        if($freeshipObj->status==SUCCESS)
        {
             $FreeshipFlag  = $freeshipObj->data; 

        }

$active_template = displayTemplate();

include "includes/htmltop.php";

//Favourites count check
$favourites_count = 0;
if (isset($_SESSION["sess_userid"]) and $_SESSION["sess_userid"] != "") {
    $userid = $_SESSION["sess_userid"];
    $favourites_count   = User::user_favourites_count($userid,$productid,$prow["product_option_id"]);
}

/* Top File Name */
include_once ("includes/" . $active_template[0]);
?>
<!--Hidden Fields for Ajax Data  Reference Do Not Delete-->
<input type="hidden" value="<?php echo $prow["artist_id"];?>" name="PRODUCT_SELLER_ID" id="PRODUCT_SELLER_ID">
<input type="hidden" value="<?php echo $prow["product_id"];?>" name="PRODUCT_ID" id="product_id">
<input type="hidden" value="<?php echo $prow['product_option_id'];?>" name="product_option_id" id="product_option_id">
<!--End Hidden Settings-->
<script src="<?php echo SITE_URL?>/js/common.js"></script>
<link href="<?php echo $site_url; ?>/themes/<?php echo $active_template[5] ?>/jquery-confirm.css" rel="stylesheet" type="text/css">
<script src="<?php echo SITE_URL?>/js/jquery-confirm.js"></script>
<script language="JavaScript" type="text/JavaScript">
    $(document).ready(function(){
        $(".review").click(function(ev) {
            ev.preventDefault();
            $("#jqStarRatingPop").modal("show");         
        });
        
         $(".seller_rating").click(function(ev) {
            ev.preventDefault();
            $("#jqSellerRatingPop").modal("show");         
        });

         //Subscription popup display
        $(".jqSubscription").click(function(ev) {
            ev.preventDefault();
            $("#jqSubscriptionPopUp").modal("show");
        });


// Numeric Validation
        $("#jQSubscriptionPeriod").keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
             // Allow: Ctrl+A
            (e.keyCode == 65 && e.ctrlKey === true) ||
             // Allow: home, end, left, right, down, up
            (e.keyCode >= 35 && e.keyCode <= 40)) {
                 // let it happen, don't do anything
                 return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });


    // Subacription Period Validation
         $("#jQSubscriptionPeriod").change(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
            var SubMode         =    '<?php echo  $subscriptionMode;?>';
            var subval    =    $("#jQSubscriptionPeriod").val();
            subval        = parseInt(subval);

         if(subval>0)  {
            if(SubMode=="Daily")
                {
                    if(subval>365)
                        {
                            alert(MSG_SUBSCRIPTION_DURATION_DAY_ALERT);
                            $("#jQSubscriptionPeriod").val('');
                        }
                }
                if(SubMode=="Monthly")
                {
                    if(subval>12)
                        {
                            alert(MSG_SUBSCRIPTION_DURATION_MONTH_ALERT);
                            $("#jQSubscriptionPeriod").val('');
                        }
                }
                 if(SubMode=="Yearly")
                {
                    if(subval>1)
                        {
                            alert(MSG_SUBSCRIPTION_DURATION_YEAR_ALERT);
                            $("#jQSubscriptionPeriod").val('');
                        }
                }
         }
            //alert(subval);
    });


    // subscription price change

    $("#jQQuanity").change(function (e) {
                  
            var txtQuantity                     =       $("#jQQuanity").val();
            var txtPrice                        =       $("#txtPrice").val();
            var txtSubscriptionPrice            =       txtQuantity *  txtPrice;
            var txtNewSubscriptionPrice         =       txtSubscriptionPrice.toFixed(2);
            $("#subscription_productprice_val").html('<?php echo $currency_attributes[0]; ?>' + "&nbsp;"+ txtNewSubscriptionPrice);
             //alert(subval);
             $("#txtPrice").val(txtNewSubscriptionPrice);
             
             
             var freeShipFlag       =   '<?php echo $FreeshipFlag;?>';
             // change shipping price according to qty
             
         if(freeShipFlag=='N')   {   
             var txtFirstItemCharge             =   $("#txtFisrtItemShipPrice").val();
             //txtFirstItemCharge                 =   parseFloat
             
             var txtAdditionalItemCharge        =   $("#txtAdditionalShipPrice").val();
             
             if(txtQuantity>1)
             {
                    var NewShippingCharge              =   parseInt(txtFirstItemCharge) + (parseInt(txtAdditionalItemCharge)*(txtQuantity-1));
             
              }else{
                    var NewShippingCharge              =   parseInt(txtFirstItemCharge);
                    
                    
              }
                            
              var NewShippingTotal                         =   NewShippingCharge.toFixed(2);
              
              $("#shipping_price").html('<?php echo $currency_attributes[0]; ?>' + "&nbsp;"+ NewShippingTotal);
              
              $("#txtSubscriptionShipPrice").val(NewShippingTotal);
                    }   
    });
    
    })
    
    
    function clickSearch()
    {
        document.frmCatalog.submit();
    }
    function addToCart()
    {
        document.add_to_cart_areaFrm.submit();
    }
    function openWindow(id)
    {
        var url = "viewimage.php?id="+id;
        window.open(url,"Image","height=500,width=500,scrollbars=yes");
    }
    function CheckStock()
    {
        var txtStock=document.getElementById("txtstock").value;

        txtStock =parseInt(txtStock);

        var txtQty=document.getElementById("txtQty").value;

        txtQty	=parseInt(txtQty);

        if(!IsNumeric(document.getElementById("txtQty").value))
        {
            alert('<?php echo NUMERIC_VALUE_MSG; ?>');
            return false;
        }
        if(txtStock==0)
        {
            alert('<?php echo STOCK_NOT_AVAILABLE_MSG; ?>');

            return false;

        }
        if(txtQty>txtStock)
        {
            alert('<?php echo STOCK_NOT_AVAILABLE_MSG; ?>');
            document.getElementById("txtQty").value=txtStock;
            return false;
        }
        else
        {
            return true;
        }
    }
    function adjustQty()
    {
        if(!IsNumeric(document.getElementById("txtQty").value))
        {
            alert('<?php echo NUMERIC_VALUE_MSG; ?>');
            return false;
        }
        var txtStock=document.getElementById("txtstock").value;
        txtStock = parseInt(txtStock);
        var txtQty=document.getElementById("txtQty").value;
        txtQty	= parseInt(txtQty);
        if(txtQty>txtStock)
        {
            document.getElementById("txtQty").value=txtStock;
            alert('<?php echo NO_STOCK_QUANTITY_ADJUSTED_MSG; ?>');
            return false;
        }
        else
        {
            return true;
        }

    }
    function IsNumeric(strString) //  check for valid numeric strings
    {
        if(!/\D/.test(strString)) return true;//IF NUMBER
        else return false;
    }
    function changeOption(obj)
    {
        //Santhosh Thomas Alexander wrote on 06/07/2011
        var productOptionID = $.trim($(obj).val());

        var postData = {product_option_id:productOptionID};

        $.ajax({url:'<?php echo SITE_URL?>/getProductOptionDetailsAjax.php',
            type:'post',
            dataType:'json',
            data:postData,
            beforeSend:function()
            {
                // showAjaxLoader($("#productDetailsTD"))
            },
            complete:function()
            {
                // hideAjaxLodaer();
            },
            success:function(reply)
            {
                if(reply.response)
                {
                    if(reply.response == 'success')
                    {
                        if(reply.value)
                        {
                            $("#bigImageDiv").html(unescape(reply.value.imageUrl));
                            $("#imgDynamicSrc").val(unescape(reply.value.image));

                            var currency = '<?php echo $currency_attributes[0]; ?>';

                            if(reply.value.show_item_status=='Y') {

                                $("#itemStatus").show();
                                var itemText = '';
                                if(reply.value.stock >0) {
                                    itemText = '<img src="<?php echo SITE_URL ?>/images/in_stock.gif" align="absmiddle">';
                                }
                                itemText += '(&nbsp;'+(reply.value.stock)+'&nbsp;) Items';

                                $("#itemStatusDetail").html(itemText);
                            }
                            $("#txtstock").val(reply.value.stock);

                            if(reply.value.stock > 0)
                            {
                                $("#add_to_cart_areaFrm").attr("action","<?php echo SITE_URL ?>/homepage_addtocart.php?productid=<?php echo $productid ?>&product_option_id="+productOptionID);
                                $("#add_to_cart_area").show('slow');
                                $("#outOfStockArea").hide('slow');

                            }else {
                                $("#add_to_cart_area").hide('slow');
                                $("#outOfStockArea").show('slow');
                            }
                            var product_price = reply.value.price;

                            var discount = reply.value.discount;
                            var product_price_actual = product_price;
                            var product_priceTxt = '';
                            if(reply.value.discount > 0)
                            {
                                $("#discountAmount").html('<b>'+reply.value.discount+'</b>%');
                                $("#discountArea").show('');

                                if(reply.value.discount_description !='')
                                {
                                    $("#discountDescription").html(reply.value.discount_description);
                                    $("#discount_descriptionArea").show();

                                }else {
                                    $("#discountDescription").html('');
                                    $("#discount_descriptionArea").hide();
                                }
                                product_price_actual = product_price - ((product_price*discount)/100);
                                product_price_actual  = product_price_actual.toFixed(2);

                                product_priceTxt = reply.value.currency+product_price_actual+'  (<strike>'+ currency + '&nbsp;'+product_price.toFixed(2)+'</strike>)';

                            }else {
                                product_priceTxt = currency+'&nbsp;'+product_price_actual.toFixed(2);
                                $("#discountArea").hide();
                                $("#discount_descriptionArea").hide();
                            }
                            $("#product_price_val").html(product_priceTxt);
                            $("#shippingWeightVal").html(reply.value.product_shipping_weight+' LBS');


                        }
                    }

                }
            }


        });
    }

</script>
<script language="javascript">
    $(document).ready(function()
    {
        $(".jqReviewShowButton").click(function()
        {
            var myContainer = $(this).parents(".jqReview");
            var myDetails 	= myContainer.find(".jqReviewDetails");

            if(myDetails.is(":visible"))
            {
                myDetails.slideUp();
            }
            else
            {
                myDetails.slideDown();
            }

        });

        /**
         * Tabs
         **/
        $(".jqTabsDetails").hide();
        $(".jqTabsDetails:first").show();
        $(".tabs-nav li:first").addClass('tabs-selected');

        $(".jqTabLink").click(function()
        {

            $(".tabs-nav li").removeClass('tabs-selected');
            $(this).parent('li').addClass('tabs-selected');
            var dvId    = $(this).attr('rel');
            $(".jqTabsDetails").slideUp('slow');
            $("#"+dvId).slideDown('slow');

            /*
                $(".jqTabsDetails:visible").slideUp('slow', function(){
                $(".jqTabsDetails:eq("+ myIndex +")").slideDown();

        });*/
        });

    });
</script>
<?php
if (!empty($product_number)) { 
    ?>
    <div class="container">
        <div class="row">
            <div class="prdetails_container">
				<section class="sec_marg">
                <div class="col-sm-12 col-lg-12 col-md-12">
                    <div class="brdcrumb_container"><?php
    $currentCategory_id = $prow['category_id'];
    echo getProductPageLink("categorydetail.php", $currentCategory_id, stripslashes($prow['product_name']))
    ?></div>
				<div class="clear"></div>
                </div>
				<div class="clear"></div>
				</section>
                <?php
                if ($_GET['msg'] == 'stock') {
                    ?>
                    <div class="clear"></div>
                    <div><?php echo SELECT_OTHER_OPT_MSG; ?> .</div>
                <?php } ?>

                <div class="prodetails_topsection"><!-- Image area-->
                    <div class="col-sm-12 col-lg-5 col-md-5">
                        <div class="prdetails_imagearea prdetails_position">
                            <?php if ($digitalFlag == 'Y') { ?><div class="digital_seal_inr"></div> <?php } ?>
                            <div class="prdetails_row" id="bigImageDiv"><?php echo $imageurl; ?></div>
                            </div>
							<div class="fleft">
                            <input type="hidden" name="imgDynamicSrc" id="imgDynamicSrc"
                                   value="<?php echo $product_image ?>"> 
                                   <div class="prdetails_thumbrow"><?php
//                                    var_dump($prow["image_big"]);
                                  
                       // Display More Images of Product
                        if (getSettingsValue('more_images') == 'Y') {
                            if ($numrows > 0) {
                                $k = 0;
                                while ($rr = mysql_fetch_array($result_im)) {
                                    $pimage = $rr["vimage_name"];
                                  if($pimage!='')  
                                    $productImageDetails[] =  $pimage;
                                }

                               
                               // echopre($productImageDetails);
                                if (count($productImageDetails) > 0) {
                                    if (strstr($product_thumb_image, "http://") || strstr($product_thumb_image, "https://") ) {
                                        $productImageDetails[]      =       $product_thumb_image;
                                    }else{
                                        //echo $productInfo            =       explode("/",$product_thumb_image);
                                        //$product_image_original     =       end($productInfo) ;
                                        $productImageDetails[]      =       $product_thumb_image;
                                    }
                                }
                                    ?>

                                    <?php
                                   $imgOpt = "";
                               if (count($productImageDetails) > 0) {
                                   foreach( array_reverse($productImageDetails) as $pKey =>  $pvals) {
                                      
                                        if (strstr($pvals, "http://") || strstr($pvals, "https://") ) {
                                            $imgOptOriginal = $pvals;
                                             $imgOpt_thumb  =  $pvals;
                                        } else {
                                            if(ENABLE_AMAZON_S3_IMAGES=="Y") {
                                                $imgOptOriginal =    AMAZON_S3_DOMAIN_URL.'products/' . $pvals;
                                                 $imgOpt_thumb    =    AMAZON_S3_DOMAIN_URL.'products/thumb_' . $pvals;
                                            }else{
                                               $imgOptOriginal =    SITE_URL.'/products/' . $pvals;
                                               $imgOpt_thumb   =    SITE_URL.'/products/thumb_' . $pvals;
                                            }
                                            /*if (file_exists(SITE_URL.'/products/' . $pvals)) { // check file exists in directory or not
                                                $imgOpt = SITE_URL.'/products/' . $pvals;
                                            }*/
                                        }
                                    
                                       //echo "<br>----".$imgOpt;
                                            ?> <a onMouseOver="movepic('<?php echo $imgOptOriginal; ?>');"
                                                   style="cursor: pointer;"> <img src="<?php echo $imgOpt_thumb; ?>" class="prdetails_imgthumb"></a>
                     <?php
                            // end image exists check
                        }//end while
                    }                                   
                                    ?>

                                    
                                    <?php
                                }
                            }
                            ?>
                            </div>
							</div>
                        
						<div class="clear"></div>
                    </div>
                    <!-- Image area ends--> 

                    <!-- Product information area-->
                    <div class="col-sm-12 col-lg-7 col-md-7">
                  
                        <div class="prdetails_infoarea">

                            <div class="prdetails_productname"><?php echo htmlentities(stripslashes(ucfirst($prow["product_name"]))); ?>
                            </div>
                       <!--Start Add to Favourites-->
                    <?php

                    if(getSettingsValue('enable_favourites')=='Y' && $favourites_count==0 && $addTofavoritesFlag=='Y') {

                        ?>

                    <div id='content' class="adtowish_container-new" >
                        <div id='confirm-dialog'>
                            <a href='#' class='confirm addtowishlish_btn' id="productwishlist" >
                                <i class="fa fa-star"></i> <span id="btn_wish" ><?php echo ADD_TO_FAVOURITES_TEXT;?></span>
                            </a>
                        </div>

                    </div>

                        <?php } if($favourites_count>0)
                            {
                            ?>
                                    <div class="fav_detaila_icon">
										<div class="fa fa-star"></div> &nbsp; <?php echo TEXT_ITEM_ADDED_FAVOURITES;?>
                                        <!--<img src="<?php echo SITE_URL?>/images/favourites_icon.png"  border="0" alt="<?php echo TEXT_ITEM_ADDED_FAVOURITES;?>" title="<?php echo TEXT_ITEM_ADDED_FAVOURITES;?>">-->
                                  </div>
                  <?php
                        }

                    ?>
                    <!--End Favourites List Button-->

                            <div class="prdetails_productinfo">
                                <div class="prdetails_productinfo_row_sep">
                                    <div class="row">
                                        <?php if ($prow["product_code"] != '') { ?>
                                            <div class="col-sm-12 col-lg-4 col-md-4">
                                                <div class="prdetails_productinfo_row">
                                                    <div class="prdetails_productinfo_row_hd">
                                                        <h4><?php echo PRODUCT_ID_TEXT; ?></h4>
                                                    </div>
                                                    <div class="prdetails_productinfo_row_desc">
                                                        <p><?php echo htmlentities(stripslashes($prow["product_code"])); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        
                                        
                                        <div class="col-sm-12 col-lg-4 col-md-4">
                                            <div class="prdetails_productinfo_row">
                                                <div class="prdetails_productinfo_row_hd">
                                                    <h4><?php echo str_replace(":", "", SELLER_TEXT1); ?></h4>
                                                </div>
                                                <div class="prdetails_productinfo_row_desc">
                                                    <p><?php echo stripslashes(ucfirst($prow['artist_name'])); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                        if (!empty($prow['storename']) || !empty($prow['artist_name'])) {
                                            ?>
                                            <div class="col-sm-12 col-lg-4 col-md-4">
                                                <div class="prdetails_productinfo_row">
                                                    <div class="prdetails_productinfo_row_hd">
                                                        <h4><?php echo TEXT_STORENAME; ?></h4>
                                                    </div>
                                                    <div class="prdetails_productinfo_row_desc">
                                                        <p>
                                                            <?php
                                                            if ($enable_seller_friendly == "Y") {
                                                                $sellerLink = (!empty($prow['storename'])) ? SITE_URL . "/stores/" . $prow['storename'] : SITE_URL . "/store/" . $prow['artist_name'];
                                                            } else {
                                                                $sellerLink = (!empty($prow['storename'])) ? SITE_URL . "/showportfolio.php?storename=" . $prow['storename'] : SITE_URL . "/showportfolio.php?artistid=" . $prow['artist_id'];
                                                            }
                                                             $sellerLinkName =  (!empty($val['storename'])) ? ucfirst($prow['storename']) : ucfirst($prow['artist_name']);                       
                                 
                                                            ?>
                                                            <a href="<?php echo $sellerLink; ?>" style="text-decoration:underline" target="_blank"><?php echo stripslashes($sellerLinkName); ?></a>
                                                        
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <div class="clear"></div>
                                <div class="row" id="product_mid_details">
                                    
                                    <div class="prdetails_productinfo_row">
                                        <?php
                                        $opt = getProductOptions($prow['product_id'], $prow['product_option_id'], array(), 'product_option');
                                        $optFlag = explode("~", $opt);
                                        if ($optFlag[0] != 0) {
                                            ?>
                                            <div class="col-sm-12 col-lg-4 col-md-4">
                                                <div class="prdetails_productinfo_row_hd">
                                                    <h4><?php echo OPTIONS;?></h4>
                                                </div>
                                            </div>
                                            <div class="col-sm-12 col-lg-8 col-md-8">
                                                <div class="prdetails_productinfo_row_desc">
                                                    <p>
                                                        <?php
                                                        $multiple_option = explode("~",getProductOptions($prow['product_id'], $prow['product_option_id'], array(), 'product_option'));
                                                        echo $multiple_option[1];
                                                        ?>
                                                    </p>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        <div class="clear"></div>
                                    </div>

                                    <?php
                                    if ($settings[1] == "Y") {
                                        $hideStock = "";
                                    } else {
                                        $hideStock = "style='display:none;'";
                                    }
                                    ?>
                                    <div class="prdetails_productinfo_row"  id="itemStatus" <?php echo $hideStock; ?>>
                                        <div class="col-sm-12 col-lg-4 col-md-4">
                                            <div class="prdetails_productinfo_row_hd">
                                                <h4><?php echo ITEM_STATUS_TEXT; ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-lg-8 col-md-8">
                                            <div class="prdetails_productinfo_row_desc" id="itemStatusDetail">
                                                <p>
                                                    <?php
                                                    // Check if product stock exists
                                                    if ($productinstock) {
                                                        ?> <span class="Stock_in_icon"><?php echo TEXT_IN_STOCK; ?>
                                                        </span> <span style="float:left; padding:5px 0 0 0 ; ">  <?php } ?> ( <?php echo $prow['product_stock'] ?>
                                                        ) Items</span> 
                                                </p>
                                               &nbsp;&nbsp;<span class="freeship_text"> <?php echo $freeship_flag_text;?> </span>
                                            </div>
                                        </div>
                                       
                                        <div class="clear"></div>
                                    </div>

                                    <?php
                                    if ($prow["discount"] != 0) {
                                        $hidediscount = '';
                                    } else {
                                        $hidediscount = 'style="display:none;"';
                                    }
                                    ?>
                                    <div class="prdetails_productinfo_row"  id="discountArea" <?php echo $hidediscount; ?>>
                                        <div class="col-sm-12 col-lg-4 col-md-4">
                                            <div class="prdetails_productinfo_row_hd">
                                                <h4><?php echo DISCOUNT_TEXT; ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-lg-8 col-md-8">
                                            <div class="prdetails_productinfo_row_desc" id="discountAmount">
                                                <p>
                                                    <?php echo htmlentities($prow["discount"]); ?> %
                                                </p>
                                            </div>
                                        </div>
                                        <div class="clear"></div>
                                    </div>

                                    <?php
                                    if ($prow["discount"] != 0 && $prow["discount_description"] != "") {
                                        ?>
                                        <div class="prdetails_productinfo_row"  id="discount_descriptionArea">
                                            <div class="col-sm-12 col-lg-4 col-md-4">
                                                <div class="prdetails_productinfo_row_hd">
                                                    <h4></h4>
                                                </div>
                                            </div>
                                            <div class="col-sm-12 col-lg-8 col-md-8">
                                                <div class="prdetails_productinfo_row_desc" id="discountDescription">
                                                    <p>
                                                        <?php echo stripslashes($prow["discount_description"]); ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="clear"></div>
                                        </div>
                                    <?php } ?>


                                    <div class="prdetails_productinfo_row"  id="discount_descriptionArea1">
                                        <div class="col-sm-12 col-lg-4 col-md-4">
                                            <div class="prdetails_productinfo_row_hd">
                                                <h4><?php echo PRODUCT_RATING_TEXT; ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-lg-8 col-md-8">
                                            <div class="prdetails_productinfo_row_desc">
                                                <p>
                                                    <?php $productRating = ProductRatingStar($productid); ?>
                                                </p>
                                            </div>
                                            <div class="prdetails_productinfo_row_desc">
                                                
                                                    <?php if ($productRating > 0) {
                                                        ?> <div class="raterowdiv"><div class="rating_<?php echo $productRating; ?>" id="rating_<?php echo $productRating; ?>"></div> </div><?php } else { ?>
                                                    
													<div id="jqNewComment" class="rate_flt"><?php echo NO_PRODUCT_RATING_TEXT; ?></div>
													
                                                <?php }
                                                ?> 
                                                    <?php if ($_SESSION["sess_userid"] != '' && checkProductRatingStatus($_SESSION["sess_userid"], $productid) == 0) {
                                                        ?>
														
                                                    <div id="jqRateProduct" class="rate_flt"><a  class="prdetails_link1"  href="#jqRatingPop" data-toggle="modal"><?php echo RATE_NOW_TEXT; ?></a></div>
													
                                                <?php } ?>
                                                
                                            </div>
                                        </div>
                                        <div class="clear"></div>
                                    <!--Subscription Area --->

                                    <?php if($subscriptionFlag=='Y') { ?>
                                        <div class="prdetails_productinfo_row"  id="discountArea">
                                        <div class="col-sm-12 col-lg-4 col-md-4">
                                            <div class="prdetails_productinfo_row_hd">
                                                <h4><?php echo SUBSCRIPTION_PERIOD_TEXT; ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-lg-8 col-md-8">
                                            <div class="prdetails_productinfo_row_desc" id="discountAmount">
                                                <p>
                                                    <?php echo $subscriptionMode_Text;?>
                                                </p>
                                            </div>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                <?php } ?>
                                    <!-- End Subscriptin Area--->
                                    </div>


                                </div>
                            </div>

                            <div class="prdetails_productprice"><span
                                    id="product_price_val"><?php if ($discountprice != 0) {
                                                    ?> <?php echo $currency_attributes[0] ?> <?php echo $discountprice; ?>
                                        (<strike><?php echo $currency_attributes[0] ?> <?php echo $display_product_price; ?>
                                        </strike>) <?php } else {
                                                    ?> <?php echo $currency_attributes[0] ?> <?php echo $display_product_price; ?>
                                    <?php } ?></span></div>
                            <?php
                            if ($productinstock) {
                                $hideCartArea = '';
                                $hideOutOfStockArea = 'style="display:none;"';
                            } else {
                                $hideCartArea = 'style="display:none;"';
                                $hideOutOfStockArea = '';
                            }
                            ?>

                            <div class="prdetails_cartgroup" id="add_to_cart_area"
                                 <?php echo $hideCartArea; ?>>
                                <form id="add_to_cart_areaFrm" name="add_to_cart_areaFrm" action="<?php echo SITE_URL ?>/homepage_addtocart.php?productid=<?php echo $prow["product_id"] ?>&product_option_id=<?php echo $prow["product_option_id"] ?>" method="post" onSubmit="return CheckStock();">
                                    <div class="prdetails_qantity">
                                        <div class="txt"><?php echo QUANTITY_TEXT; ?></div>
                                        <div class="inputbox"><input type="hidden" name="txtstock"
                                                                     value="<?php echo $prow['product_stock']; ?>" id="txtstock"> <input
                                                                     type="text" class="qantity_input" size="5" value="1" name="txtQty"
                                                                     id="txtQty" onChange="return adjustQty();"></div>
                                    </div>


                                    <div class="left">
                                   
                                        <a href="javascript:void(0);" onclick="addToCart()" class="add_to_cart_main_button"><i class="fa fa-shopping-cart"></i> <?php  echo BUY_NOW_TEXT; ?></a>
                                    
                                        <?php if($subscriptionFlag=='Y') { ?>
                                            &nbsp;&nbsp;<a href="javascript:void(0);"  class="add_to_cart_main_button-new jqSubscription"><i class="fa fa-shopping-cart"></i> <?php  echo SUBSCRIBE_NOW_TEXT .  SUBSCRIPTION_DAILY_TEXT;?></a>
                                        <?php } ?>
                                    </div>

                   
                                </form>
                                <div class="clear"></div>
                                 <div class="clear"></div>
                                    <div class="socialmediaicons_detailpage">
                    <div class="">
                        <!-- Facebook Share Button -->
                        <?php 
                        $productNameShare =htmlspecialchars(strip_tags(stripslashes($prow['product_name'])), ENT_QUOTES);
                        if(getSettingsValue('enable_fbshare')=='Y') {
                                $fbShareURL     = generalMethods::getProductdetailNavigationURL($prow['product_id']);
                                $fbShareCode    = generalMethods::faceBookShareCode($fbShareURL);
                            ?>
                        <div class="fb-share" style="width:57px !important; float:left;"><?php echo $fbShareCode;?></div>
                        <div class="fb-like" style="float:left;" data-href="<?php echo generalMethods::getProductdetailNavigationURL($prow['product_id']); ?>" data-send="true" data-layout="button_count" data-width="450" data-show-faces="true" data-share="false"></div>
                            <?php } ?>
                        <!-- End Facebook Share Button -->
                        <!-- Tweet Button -->
                        <?php if(getSettingsValue('enable_tweet')=='Y') { // ?>
                        <div class="tweetbutton" style="float:left; margin-left:1%; width:84px;">
                            <a href="http://twitter.com/share" class="twitter-share-button" data-count="horizontal" data-text="<?php echo $productNameShare ; ?>" data-url="<?php echo generalMethods::getProductdetailNavigationURL($prow['product_id']); ?>" data-counturl="<?php echo generalMethods::getProductdetailNavigationURL($prow['product_id']); ?>" data-via="<?php echo SITE_NAME; ?>">Tweet</a>
                            <script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>
                        </div>
                            <?php } ?>
                        <!-- End Tweet Button -->
                        <!-- Google Plus Share Button -->
                        <?php if(getSettingsValue('enable_gplusshare')=='Y') { ?>
                        <div class="g-plus" data-action="share" data-annotation="bubble" data-href="<?php echo generalMethods::getProductdetailNavigationURL($prow['product_id']); ?>" style="float:left;margin-left:1%; width:84px;"></div>
                        <script type="text/javascript">
                            (function() {
                                var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
                                po.src = 'https://apis.google.com/js/plusone.js';
                                var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
                            })();
                        </script>
                            <?php } ?>
                        <!-- End Google Plus Share Button -->
                        <!-- Pinterest Pin-It Button -->
                        <?php if(getSettingsValue('enable_pinit')=='Y') { ?>
                            <?php
                            $pinterestURL = generalMethods::getProductdetailNavigationURL($prow['product_id']);
                            $product_image = ($prow["image_small"]!=NULL)?$prow["image_small"]:$prow['smallimage'];
                            if (strpos($product_image, "http") === false) {
                                $pinterestImgURL = SITE_URL . "/products/" . $product_image;
                            } else {
                                $pinterestImgURL = $product_image;
                            }
                            //echo "Image-->".$pinterestImgURL;exit;
                            ?>
                        <script>function pinit_click()
                            {u=location.href;t=document.title;window.open("http://pinterest.com/pin/create/button/?url=<?php echo urlencode($pinterestURL); ?>&media=<?php echo urlencode($pinterestImgURL); ?>&description=<?php echo $productNameShare; ?>",'sharer','toolbar=0,status=0,width=626,height=436');return false;}</script>
                    <?php /* ?>    <a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode($pinterestURL); ?>&media=<?php echo urlencode($pinterestImgURL); ?>&description=<?php echo $prow['product_name']; ?>" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a><?php */ ?>
                        <img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" onclick="return pinit_click()" / style="margin-top:-12px;">
    <?php } ?>
                        

                        <!-- End Pinterest Pin-It Button -->
                    </div>
                    <div class="clear"></div>
                </div>
                            </div>
                            <div class="prdetails_cartgroup" id="outOfStockArea"
                                 <?php echo $hideOutOfStockArea; ?>>
                                <div>&nbsp;</div>
                                <div class="left"><span class="outOfStock_icon"><?php echo TEXT_OUT_OF_STOCK; ?></span></div>
                            </div>
                        </div>
                    </div>

                    <!-- Product information area ends-->

                    <div class="clear"></div>
                </div>
				<div class="col-sm-12 col-lg-12 col-md-12">
                <div class="prdetails_row product_details_div_btm">

                    <div id="container-8">
                        <ul class="tabs-nav">
                            <li><a rel="productinfo" href="javascript:;" title="<?php echo TITLE_PRODUCT_INFO; ?>"
                                   class="jqTabLink"><span><?php echo PRODUCT_INFO_TEXT; ?></span></a></li>
                            <li><a rel="manufacturer" href="javascript:;"
                                   title="<?php echo TITLE_MANUFACTUREER_DETAILS; ?>" class="jqTabLink"><span><?php echo SELLER_PORTFOLIO_TEXT; ?></span></a></li>
                            <li><a rel="ProductReviews" href="javascript:;" title="<?php echo TITLE_PRODUCT_REVIEWS; ?>"
                                   class="jqTabLink"><span><?php echo PRODUCT_REVIEWS_TEXT; ?></span></a></li>
                            <li><a rel="reviews" href="javascript:;" title="<?php echo TITLE_REVIEWS; ?>"
                                   class="jqTabLink"><span><?php echo SELLER_FEEDBACK_TEXT; ?></span></a></li>
                        </ul>

                        <div>
                            <div id="productinfo" class="tabs-container jqTabsDetails">

                                <table border="0" cellpadding="3" cellspacing="1" width="100%">
                                    <tr class="tab_tblbg">
                                        <td style="width: 190px;"><?php echo PRODUCT_NAME_TEXT; ?></td>
                                        <td><span> <?php echo htmlentities(stripslashes($prow["product_name"])); ?></span></td>
                                    </tr>

                                    <?php if($prow['product_shipping_weight']!=0 && $prow['product_shipping_weight']!=NULL){?>
                                    <tr class="tab_tblbg">
                                        <td><?php echo WEIGHT_TEXT; ?></td>
                                        <td><span class="prd_dtls" id="shippingWeightVal"> <?php echo $prow['product_shipping_weight'] . ' LBS'; ?>
                                            </span></td>
                                    </tr>
                                    <?php } ?>
                                           
                                    <tr class="tab_tblbg">
                                        <td valign="top"><?php echo PRODUCT_DESCRIPTION_TEXT; ?></td>
                                        <td><span><?php echo html_entity_decode(stripslashes($product_description_format)); ?>
                                            </span></td>
                                    </tr>
                                    <?php if ($prow["product_tags"] != '') { ?>
                                     <tr class="tab_tblbg">
                                        <td valign="top"><?php echo PRODUCT_TAG_TEXT; ?></td>
                                        <td><span><?php echo html_entity_decode(stripslashes($prow["product_tags"])); ?>
                                            </span></td>
                                    </tr>
                                    <?php } ?>
                                    <tr class="tab_tblbg">
                                        <td ><?php echo SELLER_TEXT1; ?>  </td>
                                        <td><span class="prd_dtls">  <?php echo stripslashes(ucfirst($prow['artist_name'])); ?></span></td>
                                    </tr>

                                    <tr class="tab_tblbg">
                                        <td ><?php echo SELLER_COMPANY_TEXT1; ?> </td>
                                        <td><span class="prd_dtls">  <?php echo stripslashes($prow['company']); ?></span></td>
                                    </tr>
                                </table>

                            </div>
                        </div>

                        <div id="manufacturer" style="clear: both"
                             class="tabs-container jqTabsDetails"><?php
                             $portfoliodir = SITE_URL . "/portfolios/";
                             $txtArtistPhoto = $prow["artist_photo"];
                             if ($txtArtistPhoto == "") {
                                 $sellerimageurl = "<img src='" . $portfoliodir . "noimage.jpg' width='120' height='100' border='0' >";
                             } else {
                                 $sellerimageurl = "<img src='" . $portfoliodir . $txtArtistPhoto . "' border='0' width='120' height='100' >";
                             }
                           ?>

                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr class="tab_tblbg">
                                    <td width="190" style="width: 190px;"><?php echo COMPANY_NAME_TEXT; ?></td>
                                    <td width="503"><span> <?php echo stripslashes($prow['company']); ?></span></td>

                                    <td width="619" rowspan="3" align="left" valign="top"><?php echo $sellerimageurl ?></td>
                                </tr>
                                <tr class="tab_tblbg">
                                    <td style="width: 190px;"><?php echo STATE_TEXT; ?></td>
                                    <td><span> <?php echo getCodeValue($prow['state'],2,$prow['country']) ?> &nbsp; <?php echo stripslashes($prow['city']) ?>
                                        </span></td>
                                </tr>
                                <tr class="tab_tblbg">
                                    <td style="width: 190px;"><?php echo COUNTRY_TEXT; ?></td>
                                    <td><span><?php echo getCodeValue($prow['country'],1) ?> </span></td>
                                </tr>
                                <tr class="tab_tblbg">
                                    <td colspan="3"><span><?php echo stripslashes($prow['artist_description']) ?>
                                        </span></td>
                                </tr>


                                <tr class="tab_tblbg">
                                    <td colspan="3" style="width: 190px;"><?php
                             if ($enable_seller_friendly == "Y") {
                                 $sellerLink = (!empty($prow['storename'])) ? SITE_URL . "/stores/" . $prow['storename'] : SITE_URL . "/store/" . $prow['artist_name'];
                             } else {
                                 $sellerLink = (!empty($prow['storename'])) ? SITE_URL . "/showportfolio.php?storename=" . $prow['storename'] : SITE_URL . "/showportfolio.php?artistid=" . $prow['artist_id'];
                             }
                                 ?>
                                        <a href="<?php echo $sellerLink; ?>" target="_blank"><?php echo SELLER_PORTFOLIO_LINK; ?></a>
                                    </td>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr>
                            </table>
                        </div>

                        <div id="ProductReviews" style="clear: both"
                             class="tabs-container jqTabsDetails">
                            <script language="javascript">
            			
                                // Constants for product-rating.js script
            			
                                var msgReviewPostedSuccess = '<?php echo MSG_REVIEW_POSTED_SUCCESSFULLY; ?>';
                                var msgReviewNotUpdated = '<?php echo MSG_REVIEW_NOT_UPDATED; ?>';
                                var msgReviewPosted = '<?php echo MSG_REVIEW_POSTED; ?>';
                                var msgReviewProduct = '<?php echo MSG_REVIEW_PRODUCT; ?>';
            			
                                var msgRateProduct = '<?php echo MSG_RATE_PRODUCT; ?>';
                                var msgRateNotUpdated = '<?php echo MSG_RATE_NOT_UPDATED; ?>';
                                var msgRatePosted = '<?php echo MSG_RATE_POSTED; ?>';
                                var msgRatePostedSuccess = '<?php echo MSG_RATE_POSTED_SUCCESSFULLY; ?>';
            			
                                var msgRateSeller = '<?php echo MSG_RATE_SELLER; ?>';
                                var msgSellerFeedback = '<?php echo MSG_GIVE_SELLER_FEEDBACK; ?>';
                                var msgFeedbackNotUpdated = '<?php echo MSG_FEEDBACK_NOT_UPDATED; ?>';
                                var msgFeedbackPosted = '<?php echo MSG_FEEDBACK_POSTED; ?>';
                                var msgFeedbackPostedSuccess = '<?php echo MSG_FEEDBACK_POSTED_SUCCESSFULLY; ?>';
            			
                                var msgHideDetails = '<?php echo MSG_HIDE_DETAILS; ?>';
                                var msgClickForMore = '<?php echo MSG_CLICK_FOR_MORE; ?>';

                                var SITE_URLS       = '<?php echo SITE_URL; ?>';
            			
            			
                            </script>
                         <!--   <link href="<?php echo SITE_URL ?>/style/star-rating.css" rel="stylesheet" type="text/css">
                            <script type="text/javascript" language="javascript" src="<?php echo SITE_URL ?>/js/star-rating.js"></script>
                          -->  <script language="javascript" src="<?php echo SITE_URL ?>/js/product-rating.js"></script>
                               <script language="javascript" src="<?php echo SITE_URL ?>/js/jquery-rating.js"></script>
                            <div id="jqRateImage" class="postproduct_rev" style="font: Verdana, Arial, Helvetica, sans-serif;"><?php echo $showProductReviewLink; ?></div>

                            <div id="jqNewComment1" class="revcmntsdiv"><p> </p></div>
                            <?php
                            if ($ProductReviewCount > 0) {

                                while ($reviewObj = mysql_fetch_object($rs_review)) {
                                    ?>
                                    <div class="reviecontents jqReview">
                                        <div class="clientname">
                                            <a href="javascript:;" class="jqReviewShowButton"
                                                               title="View comment">
												<h5><?php echo $reviewObj->first_name; ?> &nbsp; <?php echo $reviewObj->last_name; ?></h5>
											</a>
                                        </div>
                                        <div class="subsec"><a href="javascript:;" class="jqReviewShowButton"
                                                               title="View comment">
                                                <div class="commens_icon ">&nbsp;</div>
                                            </a>
                                            <div class="clear"></div>
                                        </div>
                                        <div class="revcmntsdiv jqReviewDetails" style="display: none">
                                            <p><?php echo stripslashes($reviewObj->vDes); ?></p>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="viewmorefdback pad10link">
                                    <?php echo $showProductReviewMoreLink; ?>
                                </div>

                                <?php
                            } else {
                                echo "&nbsp;" . AWAITING_REVIEWS_TEXT;
                            }
                            ?></div>

                        <div id="reviews" style="clear: both"
                             class="tabs-container jqTabsDetails">
                            <div class="reviews_section"><?php
                        if (checkSellerRatingStatus($prow['artist_id'], $_SESSION["sess_userid"], $productid) == 0 && $_SESSION["sess_userid"] != '') {
                                ?>
                        <div id="jqSellerRating"><a href="#" class="seller_rating" ><?php echo POST_SELLER_FEEDBACK_TEXT; ?> </a></div>

                                    <?php
                                }
                                ?>

                                <div class="review_div1"
                                     style="font-family: Verdana, Arial, Helvetica, sans-serif; color: #000000;">
                     <!--<div id="jqNewSellerComment" class="revcmntsdiv"><p></p></div>--> <?php
                            if ($totalsellerFeedbackRows > 0) {
                                while ($feedbackObj = mysql_fetch_object($rs_seller_feedback)) {
                                        ?>
                                            <div class="reviecontents jqReview">
                                                <div class="clientname">
													<a href="javascript:;" class="jqReviewShowButton"
                                                                       title="View comment">
                                                    <h5><?php echo $feedbackObj->first_name; ?>&nbsp;<?php echo $feedbackObj->last_name; ?>&nbsp;&nbsp;<span
                                                            style="float: right; padding: 0;"><strong><?php echo ON_TEXT; ?></strong>&nbsp;<?php echo dateFormat($feedbackObj->date_added, "Y-m-d", "m/d/Y"); ?></span></h5>
                                                	</a>
												</div>
                                                <div class="subsec"><a href="javascript:;" class="jqReviewShowButton"
                                                                       title="View comment">
                                                        <div class="commens_icon ">&nbsp;</div>
                                                    </a>
                                                    <div class="clear"></div>
                                                </div>

                                                <div class="revcmntsdiv jqReviewDetails" style="display: none">
                                                    <p><?php echo stripslashes($feedbackObj->feedback_content); ?></p>

                                                    <div class="ratings">
                                                        <div
                                                            class="rating_<?php echo GetSellerRatingStar($feedbackObj->artist_feedback_id) ?>"></div>
                                                    </div>

                                                </div>
                                                <div class="clear"></div>
                                            </div>
                                            <?php
                                        }
                                        ?>

                                        <div class="viewmorefdback"><a
                                                href="<?php echo SITE_URL ?>/artistfeedbacks.php?artistid=<?php echo $prow['artist_id'] ?>&productid=<?php echo $productid ?>"><?php echo MORE_SELLER_FEEDBACK_TEXT; ?> </a></div>

                                        <?php
                                    } else {
                                        echo "<br/>&nbsp;&nbsp;" . AWAITING_FEEDBACK_TEXT;
                                    }
                                    ?>
                                    <div class="clear"></div>
                                </div>
                            <?php } else echo "<div class='error_message' style='text-align:center;padding: 3% 0 0 0;'><strong>Sorry! The product is not available</strong></div>"; ?>;
                            

                            <div class="clear"></div>
                        </div>


                        <div class="clear"></div>
                    </div>

                </div>


            </div>
			</div>
            <div class="clear"></div>
        </div>
    </div>
</div>
<script language="javascript" src="<?php echo SITE_URL ?>/js/jquery-rating.js"></script>

<!-- Product Review Posting  Box -PopUp HTML Start Here-->
<div id="jqStarRatingPop" class="modal fade" tabindex="-1" data-width="560" style="display: none;">
    <form name="frmReview" method="post" action="#" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 class="modal-title"><?php echo POST_REVIEW_ON_TEXT; ?> <?php echo stripslashes($prow['product_name']); ?></h4>
    </div>   
        <div class="modal-body">
        <div class="row">
            <div id="jqLoader" style="display:none;"><img src="<?php echo SITE_URL;?>/images/loading.gif" border="0" class="loader" alt="" /></div>
            <div id="ratingArea">             
        
            <table cellpadding="1" cellspacing="1" width="100%" border="0" class="ratingBox">

                <tr>
                    <td colspan="2" align="left" class="ratingReview">
                        <textarea rows="6" cols="53" name="txtReview" id="txtReview"></textarea>
                    </td>
                </tr>
             
            </table>
       
   </div>
        </div>
    </div>
    <div class="modal-footer">
        
        
        <input type="hidden" name="hidPostId" id="hidPostId" value="<?php echo $productid ?>" />
        <button type="button" data-dismiss="modal" class="btn btn-default cancel_popbtn"><?php echo CANCEL_BUTTON; ?></button>
        <input type="button" value="<?php echo SUBMIT_BUTTON; ?>" class="jqPostRating submit_popbtn" id="comn_button_blue"/>
        
                        
       <!--<button type="button" class="btn btn-primary" class="jqPostProductRating" id="comn_button_blue1"><?php echo RATE_PRODUCT_BUTTON; ?></button>-->
    </div>
     </form>
</div>

<!-- Product Review Light Box -PopUp HTML End  Here-->

<!-- Product Rating Popup  HTML Start Here-->

<div id="jqRatingPop" class="modal fade" tabindex="-1" data-width="560" style="display: none;">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 class="modal-title"><?php echo RATE_PRODUCT_TEXT; ?>  (<?php echo stripslashes($prow['product_name']); ?>)</h4>
    </div>
    <div class="modal-body">
        <div class="row">
            <div id="jqLoader" style="display:none;"><img src="<?php echo SITE_URL; ?>/images/loading.gif" border="0" class="loader" alt="" /></div>
            <div id="ratingArea">
                <form name="frmRate" method="post" action="#" >
                    <table cellpadding="1" cellspacing="1" width="100%" border="0" class="ratingBox">

                       
                        <tr>
                            <td class="emailStoryStyle"><strong><?php echo RATE_LABEL; ?></strong></td>
                            <td>
                              <!--  <input id="input-1"  class="rating" data-size="xs" step="0.5" max="5" min="0" value="0">
                              --> <input name="star1" type="radio" class="star" value="1" />
                                <input name="star1" type="radio" class="star" value="2" />
                                <input name="star1" type="radio" class="star" value="3" />
                                <input name="star1" type="radio" class="star" value="4" />
                                <input name="star1" type="radio" class="star" value="5" />
                            </td>
                        </tr>
<tr>
                            <td align="center" colspan="2">
                                <input type="hidden" name="hidProductid" id="hidProductid" value="<?php echo $productid; ?>" />

                                <input type="hidden" name="hidProductSellerid" id="hidProductSellerid" value="<?php echo $prow['artist_id']; ?>" />
                               <!-- <input type="button" value="<?php echo RATE_PRODUCT_BUTTON; ?>" style="background-color:#333333; font-weight: bold; color:#FFFFFF; padding: 5px 8px; border:1px solid #333333; " class="jqPostProductRating" id="comn_button_blue1"/>
                                <input type="button" value="<?php echo CANCEL_BUTTON; ?>"  style="background-color:#333333; font-weight: bold; color:#FFFFFF; padding: 5px 8px; border:1px solid #333333; " class="jqProductRatingCancel" id="comn_button_blue2"/>-->
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        
        <button type="button" data-dismiss="modal" class="cancel_popbtn">Cancel</button>
        <input type="button" value="<?php echo RATE_PRODUCT_BUTTON; ?>"  class="jqPostProductRating submit_popbtn rate_popmarg" />
       <!-- <button type="button" class="btn btn-primary" class="jqPostProductRating" id="comn_button_blue1"><?php echo RATE_PRODUCT_BUTTON; ?></button>-->
    </div>
</div>

<!-- Product Rating Popup  HTML End  Here-->


<!--- Seller Rating Popup Start Here--->

<!-- Product Review Posting  Box -PopUp HTML Start Here-->
<div id="jqSellerRatingPop" class="modal fade" tabindex="-1" data-width="560" style="display: none;">
    <form name="frmSellerRating" method="post" action="#" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 class="modal-title"><?php echo POST_SELLER_FEEDBACK_TEXT1; ?>  (<?php echo stripslashes($prow['product_name']); ?>)</h4>
    </div>
    <div class="modal-body">
        <div class="row">
            <div id="jqLoader" style="display:none;"><img src="<?php echo SITE_URL; ?>/images/loading.gif" border="0" class="loader" alt="" /></div>
            <div id="ReviewArea">    
            
            <table cellpadding="1" cellspacing="1" width="100%" border="0" class="ratingBox">

                <tr>
                    <td colspan="2" align="left" class="ratingReview">
                        <textarea rows="6" cols="40" name="txtSellerReview" id="txtSellerReview"></textarea>
                    </td>
                </tr>
                <tr><td colspan="2">&nbsp; </td></tr>
                <tr>
                    <td class="emailStoryStyle" width="20%"><?php echo RATE_LABEL ?></td>
                    <td width="80%">
                        <input name="star2" type="radio" class="star" value="1" />
                        <input name="star2" type="radio" class="star" value="2" />
                        <input name="star2" type="radio" class="star" value="3" />
                        <input name="star2" type="radio" class="star" value="4" />
                        <input name="star2" type="radio" class="star" value="5" />
                        <input type="hidden" name="hidSellerPostId" id="hidSellerPostId" value="<?php echo $prow['artist_id']; ?>" />                        
                    </td>
                </tr>     
            </table>
        
      </div>
    </div>
  </div>
   <div class="modal-footer">
         <input type="hidden" name="hidSellerPostId" id="hidSellerPostId" value="<?php echo $prow['artist_id']; ?>" />
         <button type="button" data-dismiss="modal" class="btn btn-default cancel_popbtn"><?php echo CANCEL_BUTTON; ?></button>
         <input type="button" value="<?php echo SUBMIT_BUTTON; ?>" class="jqSellerRating  btn-primary submit_popbtn"/>                        
         
      
    </div>
   </form>
</div>
<!-- End Seller RAting PopUp-->

<!---Product Subscription Settings-->
<?php
     $flatRateObj   =      Products::getFlatrateValue($prow['artist_id']);
     
     if($flatRateObj->status==SUCCESS)
     {
         $flatRateObjVal    = $flatRateObj->data;
         
         $first_item_shipping_charge            =   $flatRateObjVal->first_Item_charge;
         
         $additional_item_shipping_charge       =   $flatRateObjVal->additional_Item_charge;
         
         $shippingName                          =   $flatRateObjVal->flat_rate_name;    
         
     }
     
?>
<div id="jqSubscriptionPopUp" class="modal fade" tabindex="-1" data-width="750" style="display: none;">
    <form name="frmSubscription" method="post" action="#" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 class="modal-title"><?php echo stripslashes($prow['product_name']); ?>    <br> <span class="freeship_text"> <?php echo $freeship_flag_text;?> </span></h4>
    </div>
    <div class="modal-body">
        <div class="row">
            <div id="jqLoader" style="display:none;"><img src="<?php echo SITE_URL; ?>/images/loading.gif" border="0" class="loader" alt="" /></div>
            <div id="ReviewArea">
            
            <div class="ratingBox pop-new">
            
                 <div class="pop-new-inner">
                    <div class="pop-new-inner2 pop-new-innerNP"> <?php echo SUBSCRIBE_QUANTITY_SELECTION;?></div>
                  <div class="ratingReview pop-new-inner6">
                        <select  class="form-control_small_box new-width" name="txtQty" id="jQQuanity">
                           <?php for($j=1;$j<=$prow["product_stock"];$j++) { ?>
                            <option value="<?php echo $j?>"><?php echo $j?></option>
                            <?php } ?>
                        </select>

                    </div>
                </div>
                 <div class="pop-new-inner">
                   <div class="pop-new-inner2 pop-new-innerNP"> <?php echo SUBSCRIBE_DUARTION_TEXT;?></div>
                   <div class="ratingReview pop-new-inner3">
                   <div class="pop-new-inner4">
                        <input type="text" name="txtSubscriptionPeriod" value="1" class="form-control_small_box new-width" id="jQSubscriptionPeriod" > 
                        </div>
                        <div class="pop-new-innerNP pop-new-inner5"><?php echo  $subscriptionDuration_Text;?> ( <?php echo  SUBSCRIPTION_DURATION_EXAMPLE_TEXT;?> )</div>
                    </div>
                </div>

                 <div class="pop-new-inner">
                    <div class="pop-new-inner2 pop-new-innerP">  <?php echo SUBSCRIPTION_CHARGE;?></div>
                   <div class="ratingReview pop-new-inner3">

                       <div class="prdetails_productprice jQSubscription_price"><span
                                    id="subscription_productprice_val"><?php if ($discountprice != 0) {
                                                    ?> <?php echo $currency_attributes[0] ?> <?php echo $discountprice; ?>
                                        (<strike><?php echo $currency_attributes[0] ?> <?php echo $display_product_price; ?>
                                        </strike>) <?php } else {
                                                    ?> <?php echo $currency_attributes[0] ?> <?php echo $display_product_price; ?>
                                    <?php } ?></span></div>
                        <input type="hidden" name="txtPrice" value="<?php echo $display_product_price; ?>" id="txtPrice">
                        
                   </div>
                </div>
                
  
                <?php if($FreeshipFlag=='N') { ?>
                   <div class="pop-new-inner">
                     <div class="pop-new-inner2"> <?php echo SUBSCRIPTION_SHIIPING_CHARGE;?></div>
                    <div class="ratingReview pop-new-inner3">

                       <div class="prdetails_productprice jQSubscription_price ">
                           <span
                                    id="shipping_price"> <?php echo $currency_attributes[0] ?> <?php echo number_format($first_item_shipping_charge,2,".",""); ?>   </span> <span>- ( <?php echo $shippingName;?> ) 
                                   </span></div>
                        <input type="hidden" name="txtPrice" value="<?php echo $display_product_price; ?>" id="txtPrice">
                        <input type="hidden" name="txtFisrtItemShhiddenipPrice" value="<?php echo $first_item_shipping_charge; ?>" id="txtFisrtItemShipPrice">
                        <input type="hidden" name="txtAdditionalShipPrice" value="<?php echo $additional_item_shipping_charge; ?>" id="txtAdditionalShipPrice">
                        <input type="hidden" name="txtSubscriptionShipPrice" value="" id="txtSubscriptionShipPrice">
                        <input type="hidden" name="txtSubscriptionShipName" value="<?php echo $shippingName;?>" id="txtSubscriptionShipName">
                    </div>
                
                <?php } ?>
               <!-- <tr><td colspan="2">&nbsp; </td></tr>-->
            

</div>


      </div>
    </div>
  </div>
   <div class="modal-footer">
         <input type="hidden" name=jQproductId" value="<?php echo $productid;?>" id="jQproductId">
         <input type="hidden" name=jQproductOptionId" value="<?php echo $prow["product_option_id"];?>" id="jQproductOptionId">
         <button type="button" data-dismiss="modal" class="btn btn-default cancel_popbtn"><?php echo CANCEL_BUTTON; ?></button>
         <input type="button" value="<?php echo SUBSCRIBE_SUBMIT_BUTTON; ?>" class="jqSubscriptionUpdate  btn-primary submit_popbtn"/>


    </div>
   </form>
</div>
<!--End Subscription Settings-->

<?php
include "includes/" . $active_template[2]; /* Bottom File Name */
?>
</body>
</html>
<script language="javascript" type="text/javascript">
    function movepic(img_src)
    {
        document.getElementById('itemImage').src=img_src;
        document.getElementById('imgDynamicSrc').value = img_src;
    }

    function PopWin(url,name,options){
        var ContextWindow = window.open(url,name,options);
        ContextWindow.opener = this;
        ContextWindow.focus();
    }
    function PopWinlarge(url,name,options){

        var mySplitResult = url.replace("thumb_","");
        var ContextWindow = window.open(mySplitResult,name,options);
        ContextWindow.opener = this;
        ContextWindow.focus();
    }
    function PopWinbig(url,name,options){
        var url  = document.getElementById('imgDynamicSrc').value;
        var url = url.replace("thumb_","");
        var ContextWindow = window.open(url,name,options);
        ContextWindow.opener = this;
        ContextWindow.focus();

    }

</script>
<style>
    .tableborder
    {
        border:1px solid #333333;
    }
</style>
